/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTextFieldTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.AbstractScrollWidget;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widgets.VoidWidget;
import com.cleanroommc.modularui.widgets.textfield.TextFieldHandler;
import com.cleanroommc.modularui.widgets.textfield.TextFieldRenderer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.NotNull;

public class BaseTextFieldWidget<W extends BaseTextFieldWidget<W>>
extends AbstractScrollWidget<VoidWidget, W>
implements IFocusedWidget {
    public static final DecimalFormat format = new DecimalFormat("###.###");
    public static final Pattern NATURAL_NUMS = Pattern.compile("[0-9]*([+\\-*/%^][0-9]*)*");
    public static final Pattern WHOLE_NUMS = Pattern.compile("-?[0-9]*([+\\-*/%^][0-9]*)*");
    public static final Pattern DECIMALS = Pattern.compile("[0-9]*(" + BaseTextFieldWidget.getDecimalSeparator() + "[0-9]*)?([+\\-*/%^][0-9]*(" + BaseTextFieldWidget.getDecimalSeparator() + "[0-9]*)?)*");
    public static final Pattern LETTERS = Pattern.compile("[a-zA-Z]*");
    public static final Pattern ANY = Pattern.compile(".*");
    private static final Pattern BASE_PATTERN = Pattern.compile("[^\u00a7]");
    private static final int CURSOR_BLINK_RATE = 10;
    protected TextFieldHandler handler = new TextFieldHandler(this);
    protected TextFieldRenderer renderer = new TextFieldRenderer(this.handler);
    protected Alignment textAlignment = Alignment.CenterLeft;
    protected List<String> lastText;
    protected int scrollOffset = 0;
    protected float scale = 1.0f;
    protected boolean focusOnGuiOpen;
    private int cursorTimer;
    protected Integer textColor;
    protected Integer markedColor;
    protected String hintText = null;
    protected Integer hintTextColor;

    public BaseTextFieldWidget() {
        super(new HorizontalScrollData(), null);
        this.handler.setRenderer(this.renderer);
        this.handler.setScrollArea(this.getScrollArea());
        this.padding(4, 0);
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isChildValid(VoidWidget child) {
        return false;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.handler.setGuiContext(this.getContext());
    }

    @Override
    public void afterInit() {
        super.afterInit();
        if (this.focusOnGuiOpen) {
            this.getContext().focus(this);
            this.handler.markAll();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.isFocused() && ++this.cursorTimer == 10) {
            this.renderer.toggleCursor();
            this.cursorTimer = 0;
        }
    }

    @Override
    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (transformed) {
            WidgetTextFieldTheme widgetTheme = (WidgetTextFieldTheme)this.getWidgetTheme(context.getTheme());
            this.renderer.setColor(this.textColor != null ? this.textColor.intValue() : widgetTheme.getTextColor());
            this.renderer.setCursorColor(this.textColor != null ? this.textColor.intValue() : widgetTheme.getTextColor());
            this.renderer.setMarkedColor(this.markedColor != null ? this.markedColor.intValue() : widgetTheme.getMarkedColor());
            this.setupDrawText(context, widgetTheme);
            this.drawText(context, widgetTheme);
        } else {
            Stencil.apply(1, 1, this.getArea().w() - 2, this.getArea().h() - 2, context);
        }
    }

    protected void setupDrawText(ModularGuiContext context, WidgetTextFieldTheme widgetTheme) {
        this.renderer.setSimulate(false);
        this.renderer.setScale(this.scale);
        this.renderer.setAlignment(this.textAlignment, -2.0f, this.getArea().height);
    }

    protected void drawText(ModularGuiContext context, WidgetTextFieldTheme widgetTheme) {
        if (this.handler.isTextEmpty() && this.hintText != null) {
            int c = this.renderer.getColor();
            int hintColor = this.hintTextColor != null ? this.hintTextColor.intValue() : widgetTheme.getHintColor();
            this.renderer.setColor(hintColor);
            this.renderer.draw(Collections.singletonList(this.hintText));
            this.renderer.setColor(c);
        } else {
            this.renderer.draw(this.handler.getText());
        }
        this.getScrollArea().getScrollX().setScrollSize(Math.max(0, (int)(this.renderer.getLastActualWidth() + 0.5f)));
    }

    @Override
    public WidgetTextFieldTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getTextFieldTheme();
    }

    @Override
    public boolean isFocused() {
        return this.getContext().isFocused(this);
    }

    @Override
    public void onFocus(ModularGuiContext context) {
        this.cursorTimer = 0;
        this.renderer.setCursor(true);
        this.lastText = new ArrayList<String>(this.handler.getText());
    }

    @Override
    public void onRemoveFocus(ModularGuiContext context) {
        this.renderer.setCursor(false);
        this.cursorTimer = 0;
        this.scrollOffset = 0;
        this.handler.setCursor(0, 0, true, true);
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        Interactable.Result result = super.onMousePressed(mouseButton);
        if (result != Interactable.Result.IGNORE) {
            return Interactable.Result.SUCCESS;
        }
        if (!this.isHovering()) {
            return Interactable.Result.IGNORE;
        }
        if (mouseButton == 1) {
            this.handler.clear();
        } else {
            int x = this.getContext().getMouseX() + this.getScrollX();
            int y = this.getContext().getMouseY() + this.getScrollY();
            this.handler.setCursor(this.renderer.getCursorPos(this.handler.getText(), x, y), true);
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        if (this.isFocused() && !this.getScrollArea().isDragging()) {
            int x = this.getContext().getMouseX() + this.getScrollX();
            int y = this.getContext().getMouseY() + this.getScrollY();
            this.handler.setMainCursor(this.renderer.getCursorPos(this.handler.getText(), x, y), true);
        }
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char character, int keyCode) {
        if (!this.isFocused()) {
            return Interactable.Result.IGNORE;
        }
        switch (keyCode) {
            case 28: 
            case 156: {
                if (this.getMaxLines() > 1) {
                    this.handler.newLine();
                } else {
                    this.getContext().removeFocus();
                }
                return Interactable.Result.SUCCESS;
            }
            case 1: {
                if (ModularUIConfig.escRestoreLastText) {
                    this.handler.clear();
                    this.handler.insert(this.lastText);
                }
                this.getContext().removeFocus();
                return Interactable.Result.SUCCESS;
            }
            case 203: {
                this.handler.moveCursorLeft(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 205: {
                this.handler.moveCursorRight(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 200: {
                this.handler.moveCursorUp(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 208: {
                this.handler.moveCursorDown(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 211: {
                this.handler.delete(true);
                return Interactable.Result.SUCCESS;
            }
            case 14: {
                this.handler.delete();
                return Interactable.Result.SUCCESS;
            }
        }
        if (character == '\u0000') {
            return Interactable.Result.STOP;
        }
        if (Interactable.isKeyComboCtrlC(keyCode)) {
            GuiScreen.func_146275_d((String)this.handler.getSelectedText());
            return Interactable.Result.SUCCESS;
        }
        if (Interactable.isKeyComboCtrlV(keyCode)) {
            if (this.handler.hasTextMarked()) {
                this.handler.delete();
            }
            this.handler.insert(GuiScreen.func_146277_j().replace("\u00a7", ""));
            return Interactable.Result.SUCCESS;
        }
        if (Interactable.isKeyComboCtrlX(keyCode) && this.handler.hasTextMarked()) {
            GuiScreen.func_146275_d((String)this.handler.getSelectedText());
            this.handler.delete();
            return Interactable.Result.SUCCESS;
        }
        if (Interactable.isKeyComboCtrlA(keyCode)) {
            this.handler.markAll();
            return Interactable.Result.SUCCESS;
        }
        if (BASE_PATTERN.matcher(String.valueOf(character)).matches() && this.handler.test(String.valueOf(character))) {
            if (this.handler.hasTextMarked()) {
                this.handler.delete();
            }
            this.handler.insert(String.valueOf(character));
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.STOP;
    }

    public int getMaxLines() {
        return this.handler.getMaxLines();
    }

    public ScrollData getScrollData() {
        return this.getScrollArea().getScrollX();
    }

    public List<String> getLastText() {
        return this.lastText;
    }

    public W setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setScale(float scale) {
        this.scale = scale;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setTextColor(int color) {
        this.textColor = color;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setMarkedColor(int color) {
        this.markedColor = color;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setFocusOnGuiOpen(boolean focusOnGuiOpen) {
        this.focusOnGuiOpen = focusOnGuiOpen;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W hintText(String hint) {
        this.hintText = hint;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W hintColor(int color) {
        this.hintTextColor = color;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public static char getDecimalSeparator() {
        return format.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public static char getGroupSeparator() {
        return format.getDecimalFormatSymbols().getGroupingSeparator();
    }
}

