/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser;

import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.ArgumentExtension;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.CalcStepsRegister;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.CloneCache;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Constant;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Expression;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Function;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.HeadEqBody;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.License;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.PrimitiveElement;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.SerializationUtils;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.StringModel;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.StringUtils;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.mXparser;
import java.io.Serializable;
import java.util.List;

public class Argument
extends PrimitiveElement
implements Serializable {
    private static final int serialClassID = 2;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(2);
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR = false;
    @Deprecated
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    private static final boolean SYNTAX_STATUS_UNKNOWN = false;
    public static final double ARGUMENT_INITIAL_VALUE = Double.NaN;
    public static final int NOT_FOUND = -1;
    public static final int FREE_ARGUMENT = 1;
    public static final int DEPENDENT_ARGUMENT = 2;
    public static final int RECURSIVE_ARGUMENT = 3;
    public static final int TYPE_ID = 101;
    public static String TYPE_DESC = "<NA>";
    public static final int BODY_RUNTIME = 1;
    public static final int BODY_EXTENDED = 2;
    private int argumentBodyType = 1;
    private ArgumentExtension argumentExtension = null;
    private String description = "";
    Expression argumentExpression = null;
    private String argumentName = "";
    protected boolean syntaxStatusDefinition = false;
    private String errorMessageDefinition = "";
    int argumentType = 1;
    double argumentValue = Double.NaN;
    protected Argument n = null;
    private int recursionCallsCounter = 0;
    double computingTime = 0.0;
    static int MAX_RECURSION_CALLS = mXparser.MAX_RECURSION_CALLS + 2;

    static void refreshMaxAllowedRecursionDepth() {
        MAX_RECURSION_CALLS = mXparser.MAX_RECURSION_CALLS + 2;
    }

    private static String buildErrorMessageInvalidArgumentName(String argumentName) {
        return StringModel.buildErrorMessagePatternDoesNotMatchWithExamples(argumentName, StringModel.STRING_RESOURCES.INVALID_ARGUMENT_NAME, "'x', 'x_y', 'x1', 'x_1', 'abc', ...");
    }

    private static String buildErrorMessageInvalidArgumentDefinition(String argumentDefinitionString, String argumentDefinitionExamples) {
        return StringModel.buildErrorMessagePatternDoesNotMatchWithExamples(argumentDefinitionString, StringModel.STRING_RESOURCES.INVALID_ARGUMENT_DEFINITION, argumentDefinitionExamples);
    }

    private static String buildErrorMessageInvalidArgumentDefinition(String argumentDefinitionString) {
        return Argument.buildErrorMessageInvalidArgumentDefinition(argumentDefinitionString, "'x', 'x=5', 'x=5+3/2', 'x=2*y', ...");
    }

    private void registerNoSyntaxErrorInDefinition() {
        this.syntaxStatusDefinition = true;
        this.errorMessageDefinition = StringModel.STRING_RESOURCES.NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION;
        if (this.argumentExpression == null) {
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
        }
    }

    private void registerSyntaxErrorInDefinition(String errorMessage) {
        this.syntaxStatusDefinition = false;
        this.errorMessageDefinition = errorMessage;
        if (this.argumentExpression == null) {
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
        }
    }

    public Argument(String argumentDefinitionString, PrimitiveElement ... elements) {
        super(101);
        this.analyzeArgumentDefinitionString(false, false, argumentDefinitionString, elements);
    }

    public Argument(String argumentDefinitionString, boolean forceDependent, PrimitiveElement ... elements) {
        super(101);
        this.analyzeArgumentDefinitionString(false, forceDependent, argumentDefinitionString, elements);
    }

    Argument(boolean isRecursive, String argumentDefinitionString, PrimitiveElement ... elements) {
        super(101);
        this.analyzeArgumentDefinitionString(isRecursive, false, argumentDefinitionString, elements);
    }

    private void analyzeArgumentDefinitionString(boolean isRecursive, boolean forceDependent, String argumentDefinitionString, PrimitiveElement ... elements) {
        if (argumentDefinitionString == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (elements == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_ELEMENTS_ARE_NULL);
            return;
        }
        String argumentDefinitionStringTrim = argumentDefinitionString.trim();
        if (StringUtils.regexMatch(argumentDefinitionStringTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = argumentDefinitionStringTrim;
            this.registerNoSyntaxErrorInDefinition();
            return;
        }
        if (StringUtils.regexMatch(argumentDefinitionStringTrim, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(argumentDefinitionStringTrim);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            Expression bodyExpr = new Expression(headEqBody.bodyStr, new PrimitiveElement[0]);
            bodyExpr.setDescription("{internal}");
            bodyExpr.setForwardErrorMessage(false);
            double bodyValue = bodyExpr.calculate();
            if (!forceDependent && bodyExpr.getSyntaxStatus() && !Double.isNaN(bodyValue)) {
                this.argumentExpression = new Expression(new PrimitiveElement[0]);
                this.argumentValue = bodyValue;
                this.argumentType = 1;
            } else {
                this.argumentExpression = bodyExpr;
                bodyExpr.setForwardErrorMessage(true);
                this.addDefinitions(elements);
                this.argumentType = 2;
            }
            this.argumentExpression.setDescription(this.argumentName);
            this.registerNoSyntaxErrorInDefinition();
            return;
        }
        if (isRecursive) {
            if (StringUtils.regexMatch(argumentDefinitionStringTrim, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\((\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
                HeadEqBody headEqBody = new HeadEqBody(argumentDefinitionStringTrim);
                this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
                this.argumentExpression = new Expression(headEqBody.bodyStr, elements);
                this.argumentExpression.setDescription(headEqBody.headStr);
                this.argumentType = 2;
                this.n = new Argument(headEqBody.headTokens.get((int)2).tokenStr, new PrimitiveElement[0]);
                this.registerNoSyntaxErrorInDefinition();
                return;
            }
            this.registerSyntaxErrorInDefinition(Argument.buildErrorMessageInvalidArgumentDefinition(argumentDefinitionStringTrim, "'f(n)=n*f(n-1)', 'f(n)=f(n-1)+f(n-2)'"));
            return;
        }
        this.registerSyntaxErrorInDefinition(Argument.buildErrorMessageInvalidArgumentDefinition(argumentDefinitionStringTrim));
    }

    public Argument(String argumentName, double argumentValue) {
        super(101);
        if (argumentName == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        String argumentNameTrim = argumentName.trim();
        if (!StringUtils.regexMatch(argumentNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Argument.buildErrorMessageInvalidArgumentName(argumentNameTrim));
            return;
        }
        this.argumentName = argumentNameTrim;
        this.argumentValue = argumentValue;
        this.registerNoSyntaxErrorInDefinition();
    }

    public Argument(String argumentName, ArgumentExtension argumentExtension) {
        super(101);
        if (argumentName == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (argumentExtension == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_EXTENSION_IS_NULL);
            return;
        }
        String argumentNameTrim = argumentName.trim();
        if (!StringUtils.regexMatch(argumentNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Argument.buildErrorMessageInvalidArgumentName(argumentNameTrim));
            return;
        }
        this.argumentName = argumentNameTrim;
        this.argumentExtension = argumentExtension;
        this.argumentBodyType = 2;
        this.registerNoSyntaxErrorInDefinition();
    }

    public Argument(String argumentName, String argumentExpressionString, PrimitiveElement ... elements) {
        super(101);
        if (argumentName == null || argumentExpressionString == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (elements == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_ELEMENTS_ARE_NULL);
            return;
        }
        String argumentNameTrim = argumentName.trim();
        if (!StringUtils.regexMatch(argumentNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Argument.buildErrorMessageInvalidArgumentName(argumentNameTrim));
            return;
        }
        String argumentExpressionStringTrim = argumentExpressionString.trim();
        this.argumentName = argumentNameTrim;
        this.argumentExpression = new Expression(argumentExpressionStringTrim, elements);
        this.argumentExpression.setDescription(argumentNameTrim);
        this.argumentType = 2;
        this.registerNoSyntaxErrorInDefinition();
    }

    Argument(Argument argumentToClone, boolean isThreadSafeClone, CloneCache cloneCache) {
        super(101);
        this.argumentBodyType = argumentToClone.argumentBodyType;
        this.description = argumentToClone.description;
        this.argumentName = argumentToClone.argumentName;
        this.syntaxStatusDefinition = argumentToClone.syntaxStatusDefinition;
        this.errorMessageDefinition = argumentToClone.errorMessageDefinition;
        this.argumentType = argumentToClone.argumentType;
        this.argumentValue = argumentToClone.argumentValue;
        this.recursionCallsCounter = argumentToClone.recursionCallsCounter;
        this.computingTime = argumentToClone.computingTime;
        if (argumentToClone.argumentExtension != null) {
            this.argumentExtension = argumentToClone.argumentExtension.clone();
        }
        if (isThreadSafeClone) {
            if (argumentToClone.argumentExpression != null) {
                this.argumentExpression = argumentToClone.argumentExpression.cloneForThreadSafeInternal(cloneCache);
            }
            if (argumentToClone.n != null) {
                this.n = argumentToClone.n.cloneForThreadSafeInternal(cloneCache);
            }
            return;
        }
        this.argumentExpression = argumentToClone.argumentExpression;
        this.n = argumentToClone.n;
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setVerboseMode() {
        this.argumentExpression.setVerboseMode();
    }

    public void setSilentMode() {
        this.argumentExpression.setSilentMode();
    }

    public boolean getVerboseMode() {
        return this.argumentExpression.getVerboseMode();
    }

    public boolean getRecursiveMode() {
        return this.argumentType == 3;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public void setArgumentName(String argumentName) {
        if (argumentName == null) {
            if (!this.syntaxStatusDefinition) {
                this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            }
            return;
        }
        String argumentNameTrim = argumentName.trim();
        if (this.argumentName.equals(argumentNameTrim)) {
            return;
        }
        if (!StringUtils.regexMatch(argumentNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            if (!this.syntaxStatusDefinition) {
                this.registerSyntaxErrorInDefinition(Argument.buildErrorMessageInvalidArgumentName(argumentNameTrim));
            }
            return;
        }
        this.argumentName = argumentNameTrim;
        this.setExpressionModifiedFlags();
        this.registerNoSyntaxErrorInDefinition();
    }

    public void setArgumentExpressionString(String argumentExpressionString) {
        if (argumentExpressionString == null) {
            if (!this.syntaxStatusDefinition) {
                this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            }
            return;
        }
        String argumentExpressionStringTrim = argumentExpressionString.trim();
        this.argumentExpression.setExpressionString(argumentExpressionStringTrim);
        this.argumentType = 2;
        this.argumentBodyType = 1;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public String getArgumentExpressionString() {
        return this.argumentExpression.getExpressionString();
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentValue(double argumentValue) {
        this.argumentType = 1;
        this.argumentBodyType = 1;
        this.argumentValue = argumentValue;
    }

    public int getArgumentBodyType() {
        return this.argumentBodyType;
    }

    public boolean checkSyntax() {
        if (!this.syntaxStatusDefinition) {
            return false;
        }
        if (this.argumentName.isEmpty()) {
            return false;
        }
        if (this.argumentBodyType == 2) {
            return this.argumentExtension != null;
        }
        if (this.argumentType == 1) {
            return true;
        }
        return this.argumentExpression.checkSyntax();
    }

    public String getErrorMessage() {
        if (!this.syntaxStatusDefinition) {
            return this.errorMessageDefinition;
        }
        if (this.argumentName.isEmpty()) {
            return this.errorMessageDefinition;
        }
        if (this.argumentBodyType == 2 && this.argumentExtension == null) {
            return this.errorMessageDefinition;
        }
        if (this.argumentType == 1) {
            return this.errorMessageDefinition;
        }
        String argumentExpressionErrorMessage = this.argumentExpression.getErrorMessage();
        if (!this.errorMessageDefinition.isEmpty() && argumentExpressionErrorMessage.isEmpty()) {
            return this.errorMessageDefinition;
        }
        return argumentExpressionErrorMessage;
    }

    public double getArgumentValue() {
        return this.getArgumentValue(null);
    }

    public double getArgumentValue(CalcStepsRegister calcStepsRegister) {
        CalcStepsRegister.setUserArgument(calcStepsRegister, this);
        this.computingTime = 0.0;
        if (!this.syntaxStatusDefinition) {
            return Double.NaN;
        }
        if (this.argumentBodyType == 2) {
            License.checkLicense();
            long startTime = System.currentTimeMillis();
            double value = this.argumentExtension.getArgumentValue();
            this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            return value;
        }
        if (this.argumentType == 1) {
            return this.argumentValue;
        }
        ++this.recursionCallsCounter;
        if (this.recursionCallsCounter >= MAX_RECURSION_CALLS) {
            --this.recursionCallsCounter;
            return Double.NaN;
        }
        double value = this.argumentExpression.calculate(calcStepsRegister);
        --this.recursionCallsCounter;
        this.computingTime = this.argumentExpression.computingTime;
        return value;
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        if (elements == null) {
            return;
        }
        this.argumentExpression.addDefinitions(elements);
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        if (elements == null) {
            return;
        }
        this.argumentExpression.removeDefinitions(elements);
    }

    public void addArguments(Argument ... arguments) {
        if (arguments == null) {
            return;
        }
        this.argumentExpression.addArguments(arguments);
    }

    public void defineArguments(String ... argumentsNames) {
        if (argumentsNames == null) {
            return;
        }
        this.argumentExpression.defineArguments(argumentsNames);
    }

    public void defineArgument(String argumentName, double argumentValue) {
        if (argumentName == null) {
            return;
        }
        this.argumentExpression.defineArgument(argumentName, argumentValue);
    }

    public int getArgumentIndex(String argumentName) {
        if (argumentName == null) {
            return -1;
        }
        return this.argumentExpression.getArgumentIndex(argumentName);
    }

    public Argument getArgument(String argumentName) {
        if (argumentName == null) {
            return null;
        }
        return this.argumentExpression.getArgument(argumentName);
    }

    public Argument getArgument(int argumentIndex) {
        if (argumentIndex < 0) {
            return null;
        }
        return this.argumentExpression.getArgument(argumentIndex);
    }

    public int getArgumentsNumber() {
        if (this.argumentType != 2) {
            return 0;
        }
        return this.argumentExpression.getArgumentsNumber();
    }

    public void removeArguments(String ... argumentsNames) {
        if (argumentsNames == null) {
            return;
        }
        this.argumentExpression.removeArguments(argumentsNames);
    }

    public void removeArguments(Argument ... arguments) {
        if (arguments == null) {
            return;
        }
        this.argumentExpression.removeArguments(arguments);
    }

    public void removeAllArguments() {
        this.argumentExpression.removeAllArguments();
    }

    public void addConstants(Constant ... constants) {
        if (constants == null) {
            return;
        }
        this.argumentExpression.addConstants(constants);
    }

    public void addConstants(List<Constant> constantsList) {
        if (constantsList == null) {
            return;
        }
        this.argumentExpression.addConstants(constantsList);
    }

    public void defineConstant(String constantName, double constantValue) {
        if (constantName == null) {
            return;
        }
        this.argumentExpression.defineConstant(constantName, constantValue);
    }

    public int getConstantIndex(String constantName) {
        if (constantName == null) {
            return -1;
        }
        return this.argumentExpression.getConstantIndex(constantName);
    }

    public Constant getConstant(String constantName) {
        if (constantName == null) {
            return null;
        }
        return this.argumentExpression.getConstant(constantName);
    }

    public Constant getConstant(int constantIndex) {
        if (constantIndex < 0) {
            return null;
        }
        return this.argumentExpression.getConstant(constantIndex);
    }

    public int getConstantsNumber() {
        if (this.argumentType != 2) {
            return 0;
        }
        return this.argumentExpression.getConstantsNumber();
    }

    public void removeConstants(String ... constantsNames) {
        if (constantsNames == null) {
            return;
        }
        this.argumentExpression.removeConstants(constantsNames);
    }

    public void removeConstants(Constant ... constants) {
        if (constants == null) {
            return;
        }
        this.argumentExpression.removeConstants(constants);
    }

    public void removeAllConstants() {
        this.argumentExpression.removeAllConstants();
    }

    public void addFunctions(Function ... functions) {
        if (functions == null) {
            return;
        }
        this.argumentExpression.addFunctions(functions);
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        if (functionName == null || functionExpressionString == null || argumentsNames == null) {
            return;
        }
        this.argumentExpression.defineFunction(functionName, functionExpressionString, argumentsNames);
    }

    public int getFunctionIndex(String functionName) {
        if (functionName == null) {
            return -1;
        }
        return this.argumentExpression.getFunctionIndex(functionName);
    }

    public Function getFunction(String functionName) {
        if (functionName == null) {
            return null;
        }
        return this.argumentExpression.getFunction(functionName);
    }

    public Function getFunction(int functionIndex) {
        if (functionIndex < 0) {
            return null;
        }
        return this.argumentExpression.getFunction(functionIndex);
    }

    public int getFunctionsNumber() {
        if (this.argumentType != 2) {
            return 0;
        }
        return this.argumentExpression.getFunctionsNumber();
    }

    public void removeFunctions(String ... functionsNames) {
        if (functionsNames == null) {
            return;
        }
        this.argumentExpression.removeFunctions(functionsNames);
    }

    public void removeFunctions(Function ... functions) {
        if (functions == null) {
            return;
        }
        this.argumentExpression.removeFunctions(functions);
    }

    public void removeAllFunctions() {
        this.argumentExpression.removeAllFunctions();
    }

    void addRelatedExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        this.argumentExpression.addRelatedExpression(expression);
    }

    void removeRelatedExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        this.argumentExpression.removeRelatedExpression(expression);
    }

    void setExpressionModifiedFlags() {
        this.argumentExpression.setExpressionModifiedFlag();
    }

    public Argument clone() {
        return new Argument(this, false, null);
    }

    Argument cloneForThreadSafeInternal(CloneCache cloneCache) {
        Argument argumentClone = cloneCache.getArgumentClone(this);
        if (argumentClone == null) {
            cloneCache.cacheCloneInProgress(this);
            argumentClone = new Argument(this, true, cloneCache);
            cloneCache.clearCloneInProgress(this);
            cloneCache.cacheArgumentClone(this, argumentClone);
        }
        return argumentClone;
    }

    Argument cloneForThreadSafeInternal(Expression relatedExpressionThatInitiatedClone, CloneCache cloneCache) {
        Argument argumentClone = this.cloneForThreadSafeInternal(cloneCache);
        argumentClone.addRelatedExpression(relatedExpressionThatInitiatedClone);
        return argumentClone;
    }

    public Argument cloneForThreadSafe() {
        CloneCache cloneCache = new CloneCache();
        Argument argumentClone = this.cloneForThreadSafeInternal(cloneCache);
        cloneCache.addAllAtTheEndElements();
        cloneCache.clearCache();
        return argumentClone;
    }
}

