/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.drawable.text.RichTextCompiler;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.widget.sizer.Area;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class TextRenderer {
    public static final TextRenderer SHARED = new TextRenderer();
    protected float maxWidth = -1.0f;
    protected float maxHeight = -1.0f;
    protected int x = 0;
    protected int y = 0;
    protected Alignment alignment = Alignment.TopLeft;
    protected float scale = 1.0f;
    protected boolean shadow = false;
    protected int color = 0;
    protected boolean simulate;
    protected float lastActualWidth = 0.0f;
    protected float lastTrimmedWidth = 0.0f;
    protected float lastActualHeight = 0.0f;
    protected float lastTrimmedHeight = 0.0f;
    protected float lastX = 0.0f;
    protected float lastY = 0.0f;
    protected boolean hardWrapOnBorder = true;
    protected boolean scrollOnOverflow = false;

    public void setAlignment(Alignment alignment, float maxWidth) {
        this.setAlignment(alignment, maxWidth, -1.0f);
    }

    public void setAlignment(Alignment alignment, float maxWidth, float maxHeight) {
        this.alignment = alignment;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setHardWrapOnBorder(boolean hardWrapOnBorder) {
        this.hardWrapOnBorder = hardWrapOnBorder;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void draw(String text) {
        if (!(!(this.maxWidth <= 0.0f) && this.hardWrapOnBorder || text.contains("\n'"))) {
            this.drawSimple(text);
        } else {
            this.draw(Collections.singletonList(text));
        }
    }

    public void draw(List<String> lines) {
        this.drawMeasuredLines(this.measureLines(lines));
    }

    protected void drawMeasuredLines(List<Line> measuredLines) {
        float maxW = 0.0f;
        int y0 = this.getStartYOfLines(measuredLines.size());
        for (Line measuredLine : measuredLines) {
            int x0 = this.getStartX(measuredLine.width);
            maxW = Math.max(maxW, measuredLine.width);
            this.draw(measuredLine.text, x0, y0);
            y0 += (int)this.getFontHeight();
        }
        this.lastActualWidth = this.maxWidth > 0.0f ? Math.min(maxW, this.maxWidth) : maxW;
        this.lastActualHeight = (float)measuredLines.size() * this.getFontHeight();
        this.lastTrimmedWidth = Math.max(0.0f, this.lastActualWidth - this.scale);
        this.lastTrimmedHeight = Math.max(0.0f, this.lastActualHeight - this.scale);
    }

    public void drawSimple(String text) {
        float w = (float)TextRenderer.getFontRenderer().func_78256_a(text) * this.scale;
        int y = this.getStartYOfLines(1);
        int x = this.getStartX(w);
        this.draw(text, x, y);
        this.lastActualWidth = w;
        this.lastActualHeight = this.getFontHeight();
        this.lastTrimmedWidth = Math.max(0.0f, this.lastActualWidth - this.scale);
        this.lastTrimmedHeight = Math.max(0.0f, this.lastActualHeight - this.scale);
    }

    public List<Line> measureLines(List<String> lines) {
        ArrayList<Line> measuredLines = new ArrayList<Line>();
        for (String line : lines) {
            if (this.hardWrapOnBorder) {
                for (String subLine : this.wrapLine(line)) {
                    measuredLines.add(this.line(subLine));
                }
                continue;
            }
            measuredLines.add(this.line(line));
        }
        return measuredLines;
    }

    public List<ITextLine> compile(List<Object> rawText) {
        return RichTextCompiler.INSTANCE.compileLines(TextRenderer.getFontRenderer(), rawText, (int)this.maxWidth, this.scale);
    }

    public List<ITextLine> compileAndDraw(GuiContext context, List<Object> raw) {
        List<ITextLine> lines = this.compile(raw);
        this.drawCompiled(context, lines);
        return lines;
    }

    public void drawCompiled(GuiContext context, List<ITextLine> lines) {
        int height = 0;
        int width = 0;
        for (ITextLine line : lines) {
            height += line.getHeight(TextRenderer.getFontRenderer());
            width = Math.max(width, line.getWidth());
        }
        if (!this.simulate) {
            GlStateManager.pushMatrix();
            GlStateManager.translate(this.x, this.y, 10.0f);
            GlStateManager.scale(this.scale, this.scale, 1.0f);
            GlStateManager.translate(-this.x, -this.y, 0.0f);
        }
        int y0 = this.getStartY(height, height);
        this.lastY = y0;
        for (ITextLine line : lines) {
            int x0 = this.getStartX(width, line.getWidth());
            if (!this.simulate) {
                line.draw(context, TextRenderer.getFontRenderer(), x0, y0, this.color, this.shadow);
            }
            y0 += line.getHeight(TextRenderer.getFontRenderer());
        }
        if (!this.simulate) {
            GlStateManager.popMatrix();
        }
        this.lastActualWidth = this.maxWidth > 0.0f ? Math.min((float)width * this.scale, this.maxWidth) : (float)width * this.scale;
        this.lastActualHeight = (float)height * this.scale;
        this.lastTrimmedWidth = Math.max(0.0f, this.lastActualWidth - this.scale);
        this.lastTrimmedHeight = Math.max(0.0f, this.lastActualHeight - this.scale);
    }

    public void drawCut(String text) {
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Scrolling text can't wrap!");
        }
        this.drawCut(this.line(text));
    }

    public void drawCut(Line line) {
        if (line.width > this.maxWidth) {
            String cutText = TextRenderer.getFontRenderer().func_78269_a(line.getText(), (int)(this.maxWidth - 6.0f)) + "...";
            this.drawMeasuredLines(Collections.singletonList(this.line(cutText)));
        } else {
            this.drawMeasuredLines(Collections.singletonList(line));
        }
    }

    public void drawScrolling(Line line, int scroll, Area area, GuiContext context) {
        if (line.getWidth() <= this.maxWidth) {
            this.drawMeasuredLines(Collections.singletonList(line));
            return;
        }
        String drawString = line.getText();
        Area.SHARED.set(this.x, Integer.MIN_VALUE, this.x + (int)this.maxWidth, Integer.MAX_VALUE);
        Stencil.apply(Area.SHARED, context);
        GlStateManager.translate(-(scroll %= (int)(line.width + 1.0f)), 0.0f, 0.0f);
        this.drawMeasuredLines(Collections.singletonList(this.line(drawString)));
        GlStateManager.translate(scroll, 0.0f, 0.0f);
        Stencil.remove();
    }

    public List<String> wrapLine(String line) {
        return this.maxWidth > 0.0f ? TextRenderer.getFontRenderer().func_78271_c(line, (int)(this.maxWidth / this.scale)) : Collections.singletonList(line);
    }

    public boolean wouldFit(List<String> text) {
        if (this.maxHeight > 0.0f && this.maxHeight < (float)text.size() * this.getFontHeight() - this.scale) {
            return false;
        }
        if (this.maxWidth > 0.0f) {
            for (String line : text) {
                if (!(this.maxWidth < (float)TextRenderer.getFontRenderer().func_78256_a(line))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxWidth(List<String> lines) {
        if (lines.isEmpty()) {
            return 0;
        }
        List<Line> measuredLines = this.measureLines(lines);
        float w = 0.0f;
        for (Line measuredLine : measuredLines) {
            w = Math.max(w, measuredLine.getWidth());
        }
        return (int)Math.ceil(w);
    }

    protected int getStartYOfLines(int lines) {
        return this.getStartY((float)lines * this.getFontHeight() - this.scale);
    }

    protected int getStartY(float height) {
        return this.getStartY(this.maxHeight, height);
    }

    protected int getStartY(float maxHeight, float height) {
        if (this.alignment.y > 0.0f && maxHeight > 0.0f && height != maxHeight) {
            return (int)((float)this.y + maxHeight * this.alignment.y - height * this.alignment.y);
        }
        return this.y;
    }

    protected int getStartX(float lineWidth) {
        return this.getStartX(this.maxWidth, lineWidth);
    }

    protected int getStartX(float maxWidth, float lineWidth) {
        if (this.alignment.x > 0.0f && maxWidth > 0.0f) {
            return (int)((float)this.x + maxWidth * this.alignment.x - lineWidth * this.alignment.x);
        }
        return this.x;
    }

    protected void draw(String text, float x, float y) {
        if (this.simulate) {
            return;
        }
        Platform.setupDrawFont();
        GlStateManager.pushMatrix();
        GlStateManager.scale(this.scale, this.scale, 0.0f);
        GlStateManager.disableLighting();
        TextRenderer.getFontRenderer().func_85187_a(text, (int)(x / this.scale), (int)(y / this.scale), this.color, this.shadow);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.popMatrix();
    }

    public int getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public float getFontHeight() {
        return (float)TextRenderer.getFontRenderer().field_78288_b * this.scale;
    }

    public float getLastActualHeight() {
        return this.lastActualHeight;
    }

    public float getLastActualWidth() {
        return this.lastActualWidth;
    }

    public float getLastTrimmedWidth() {
        return this.lastTrimmedWidth;
    }

    public float getLastTrimmedHeight() {
        return this.lastTrimmedHeight;
    }

    @SideOnly(value=Side.CLIENT)
    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public Line line(String text) {
        return new Line(text, (float)TextRenderer.getFontRenderer().func_78256_a(text) * this.scale);
    }

    public static class Line {
        private final String text;
        private final float width;

        public Line(String text, float width) {
            this.text = text;
            this.width = width;
        }

        public String getText() {
            return this.text;
        }

        public float getWidth() {
            return this.width;
        }

        public int upperWidth() {
            return (int)(this.width + 1.0f);
        }

        public int lowerWidth() {
            return (int)(this.width + 1.0f);
        }
    }
}

