/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widgets.layout.IExpander;

public class Flow
extends ParentWidget<Flow>
implements ILayoutWidget,
IExpander {
    private final GuiAxis axis;
    private Alignment.MainAxis maa = Alignment.MainAxis.START;
    private Alignment.CrossAxis caa = Alignment.CrossAxis.CENTER;
    private int spaceBetween = 0;

    public static Flow row() {
        return new Flow(GuiAxis.X);
    }

    public static Flow column() {
        return new Flow(GuiAxis.Y);
    }

    public Flow(GuiAxis axis) {
        this.axis = axis;
        this.sizeRel(1.0f, 1.0f);
    }

    @Override
    public void layoutWidgets() {
        if (!this.hasChildren()) {
            return;
        }
        boolean hasSize = this.resizer().isSizeCalculated(this.axis);
        int size = this.getArea().getSize(this.axis);
        Box padding = this.getArea().getPadding();
        Alignment.MainAxis maa = this.maa;
        if (!hasSize && maa != Alignment.MainAxis.START) {
            if (this.flex().dependsOnChildren(this.axis)) {
                maa = Alignment.MainAxis.START;
            } else {
                throw new IllegalStateException("Alignment.MainAxis other than start need the size to be calculated!");
            }
        }
        if (maa == Alignment.MainAxis.SPACE_BETWEEN && this.getChildren().size() == 1) {
            maa = Alignment.MainAxis.CENTER;
        }
        int space = this.spaceBetween;
        int totalSize = 0;
        int expandedAmount = 0;
        int amount = 0;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasPos(this.axis)) continue;
            ++amount;
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                totalSize += widget.getArea().getMargin().getTotal(this.axis);
                continue;
            }
            totalSize += widget.getArea().requestedSize(this.axis);
        }
        if (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND) {
            if (expandedAmount > 0) {
                maa = Alignment.MainAxis.START;
            } else {
                space = 0;
            }
        }
        totalSize += space * (this.getChildren().size() - 1);
        if (expandedAmount > 0 && hasSize) {
            int newSize = (size - totalSize - padding.getTotal(this.axis)) / expandedAmount;
            for (IWidget widget : this.getChildren()) {
                if (widget.flex().hasPos(this.axis) || !widget.flex().isExpanded()) continue;
                widget.getArea().setSize(this.axis, newSize);
                widget.resizer().setSizeResized(this.axis, true);
            }
        }
        int lastP = padding.getStart(this.axis);
        if (hasSize) {
            if (maa == Alignment.MainAxis.CENTER) {
                lastP = (int)((float)size / 2.0f - (float)totalSize / 2.0f);
            } else if (maa == Alignment.MainAxis.END) {
                lastP = size - totalSize;
            }
        }
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasPos(this.axis)) continue;
            Box margin = widget.getArea().getMargin();
            widget.getArea().setRelativePoint(this.axis, lastP + margin.getStart(this.axis));
            widget.resizer().setPosResized(this.axis, true);
            widget.resizer().setMarginPaddingApplied(this.axis, true);
            lastP += widget.getArea().requestedSize(this.axis) + space;
            if (!hasSize || maa != Alignment.MainAxis.SPACE_BETWEEN) continue;
            lastP += (size - totalSize) / (this.getChildren().size() - 1);
        }
    }

    @Override
    public void postLayoutWidgets() {
        GuiAxis other = this.axis.getOther();
        int width = this.getArea().getSize(other);
        Box padding = this.getArea().getPadding();
        boolean hasWidth = this.resizer().isSizeCalculated(other);
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasPos(this.axis)) continue;
            Box margin = widget.getArea().getMargin();
            if (widget.flex().hasPos(other) || !widget.resizer().isSizeCalculated(other)) continue;
            int x = margin.getStart(other) + padding.getStart(other);
            if (hasWidth) {
                if (this.caa == Alignment.CrossAxis.CENTER) {
                    x = (int)((float)width / 2.0f - (float)widget.getArea().getSize(other) / 2.0f);
                } else if (this.caa == Alignment.CrossAxis.END) {
                    x = width - widget.getArea().getSize(other) - margin.getEnd(other) - padding.getStart(other);
                }
            }
            widget.getArea().setRelativePoint(other, x);
            widget.resizer().setPosResized(other, true);
            widget.resizer().setMarginPaddingApplied(other, true);
        }
    }

    public Flow crossAxisAlignment(Alignment.CrossAxis caa) {
        this.caa = caa;
        return this;
    }

    public Flow mainAxisAlignment(Alignment.MainAxis maa) {
        this.maa = maa;
        return this;
    }

    public Flow childPadding(int spaceBetween) {
        this.spaceBetween = spaceBetween;
        return this;
    }

    public GuiAxis getAxis() {
        return this.axis;
    }

    @Override
    public GuiAxis getExpandAxis() {
        return this.axis;
    }
}

