/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fluid;

import codechicken.nei.recipe.StackInfo;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.utils.fluid.IOverflowableTank;
import gregtech.api.util.GTUtility;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;

public class FluidInteractions {
    public static FluidStack getFluidForRealItem(ItemStack itemStack) {
        FluidStack fluidStack = null;
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item;
            fluidStack = container.getFluid(itemStack);
        }
        if (fluidStack == null) {
            fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        }
        if (fluidStack == null && ModularUI.isNEILoaded) {
            fluidStack = StackInfo.getFluid((ItemStack)itemStack);
        }
        if (ModularUI.isGT5ULoaded && fluidStack == null) {
            fluidStack = GTUtility.getFluidForFilledItem((ItemStack)itemStack, (boolean)true);
        }
        return fluidStack;
    }

    public static FluidStack getFluidForPhantomItem(ItemStack itemStack) {
        FluidStack fluidStack = null;
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item;
            fluidStack = container.getFluid(itemStack.func_77946_l());
        }
        if (fluidStack == null) {
            fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack.func_77946_l());
        }
        if (fluidStack == null && ModularUI.isNEILoaded) {
            fluidStack = StackInfo.getFluid((ItemStack)itemStack.func_77946_l());
        }
        if (ModularUI.isGT5ULoaded && fluidStack == null) {
            fluidStack = GTUtility.getFluidForFilledItem((ItemStack)itemStack, (boolean)true);
        }
        return fluidStack;
    }

    public static ItemStack fillFluidContainer(FluidStack fluidStack, ItemStack itemStack) {
        ItemStack filledContainer = FluidInteractions.fillFluidContainerWithoutIFluidContainerItem(fluidStack, itemStack);
        if (filledContainer == null) {
            filledContainer = FluidInteractions.fillFluidContainerWithIFluidContainerItem(fluidStack, itemStack);
        }
        if (filledContainer == null) {
            filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack);
            FluidStack newFluid = FluidInteractions.getFluidForRealItem(filledContainer);
            fluidStack.amount -= newFluid.amount;
        }
        return filledContainer;
    }

    public static ItemStack fillFluidContainerWithoutIFluidContainerItem(FluidStack fluidStack, ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GTUtility.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack, (boolean)true, (boolean)false);
        }
        return null;
    }

    public static ItemStack fillFluidContainerWithIFluidContainerItem(FluidStack fluidStack, ItemStack itemStack) {
        IFluidContainerItem itemContainer;
        int tFilledAmount;
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem && (tFilledAmount = (itemContainer = (IFluidContainerItem)item).fill(itemStack, fluidStack, true)) > 0) {
            fluidStack.amount -= tFilledAmount;
            return itemStack;
        }
        return null;
    }

    public static ItemStack getContainerForFilledItem(ItemStack itemStack) {
        Item item;
        ItemStack stack = FluidInteractions.getContainerForFilledItemWithoutIFluidContainerItem(itemStack);
        if (stack == null && (item = itemStack.func_77973_b()) instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item;
            stack = itemStack.func_77946_l();
            container.drain(stack, Integer.MAX_VALUE, true);
        }
        if (stack == null) {
            stack = FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack.func_77946_l());
        }
        return stack;
    }

    public static ItemStack getContainerForFilledItemWithoutIFluidContainerItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GTUtility.getContainerForFilledItem((ItemStack)itemStack, (boolean)false);
        }
        return null;
    }

    public static int getRealCapacity(IFluidTank fluidTank) {
        if (fluidTank instanceof IOverflowableTank) {
            IOverflowableTank overflowable = (IOverflowableTank)fluidTank;
            return overflowable.getRealCapacity();
        }
        return fluidTank.getCapacity();
    }
}

