/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.api.widget.Interactable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.network.PacketBuffer;

public class KeyboardData {
    public final Side side;
    public final char character;
    public final int keycode;
    public final boolean shift;
    public final boolean ctrl;
    public final boolean alt;

    public KeyboardData(Side side, char character, int keycode, boolean shift, boolean ctrl, boolean alt) {
        this.side = side;
        this.character = character;
        this.keycode = keycode;
        this.shift = shift;
        this.ctrl = ctrl;
        this.alt = alt;
    }

    public boolean isClient() {
        return this.side.isClient();
    }

    public void writeToPacket(PacketBuffer buffer) {
        buffer.writeChar((int)this.character);
        buffer.func_150787_b(this.keycode);
        byte data = 0;
        if (this.shift) {
            data = (byte)(data | 1);
        }
        if (this.ctrl) {
            data = (byte)(data | 2);
        }
        if (this.alt) {
            data = (byte)(data | 4);
        }
        buffer.writeByte((int)data);
    }

    public static KeyboardData readPacket(PacketBuffer buffer) {
        char character = buffer.readChar();
        int keycode = buffer.func_150792_a();
        byte data = buffer.readByte();
        return new KeyboardData(Side.SERVER, character, keycode, (data & 1) != 0, (data & 2) != 0, (data & 4) != 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static KeyboardData create(char character, int keycode) {
        return new KeyboardData(Side.CLIENT, character, keycode, Interactable.hasShiftDown(), Interactable.hasControlDown(), Interactable.hasAltDown());
    }
}

