/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.mixinplugin;

import com.cleanroommc.modularui.mixinplugin.TargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public enum Mixins {
    EntityAccessor("minecraft.EntityAccessor", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    FontRendererAccessor("minecraft.FontRendererAccessor", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    ForgeHooksClientMixin("forge.ForgeHooksClientMixin", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    GuiAccessor("minecraft.GuiAccessor", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    GuiButtonMixin("minecraft.GuiButtonMixin", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    GuiContainerAccessor("minecraft.GuiContainerAccessor", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    GuiContainerMixin("minecraft.GuiContainerMixin", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    GuiScreenAccessor("minecraft.GuiScreenAccessor", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    GuiScreenMixin("minecraft.GuiScreenMixin", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    MinecraftMixin("minecraft.MinecraftMixin", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    SimpleResourceAccessor("minecraft.SimpleResourceAccessor", Phase.EARLY, Side.CLIENT, TargetedMod.VANILLA),
    ContainerAccessor("minecraft.ContainerAccessor", Phase.EARLY, Side.BOTH, TargetedMod.VANILLA),
    SimpleNetworkWrapperMixin("forge.SimpleNetworkWrapperMixin", Phase.EARLY, Side.BOTH, TargetedMod.VANILLA),
    ThaumcraftMixin("thaumcraft.ClientTickEventsFMLMixin", Phase.LATE, Side.CLIENT, TargetedMod.THAUMCRAFT);

    public final String mixinClass;
    public final Phase phase;
    private final Side side;
    private final List<TargetedMod> targetedMods;

    private Mixins(String mixinClass, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = Phase.LATE;
        this.side = Side.BOTH;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    private Mixins(String mixinClass, Phase phase, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = phase;
        this.side = Side.BOTH;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    private Mixins(String mixinClass, Side side, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = Phase.LATE;
        this.side = side;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    private Mixins(String mixinClass, Phase phase, Side side, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = phase;
        this.side = side;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    public boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.allModsLoaded(this.targetedMods, loadedCoreMods, loadedMods);
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && !loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    public static enum Phase {
        EARLY,
        LATE;

    }

    static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

