/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api;

import com.cleanroommc.modularui.mixins.early.minecraft.GuiContainerAccessor;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.screen.ModularScreen;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public interface IMuiScreen {
    @NotNull
    public ModularScreen getScreen();

    @ApiStatus.NonExtendable
    default public void handleDrawBackground(int tint, IntConsumer drawFunction) {
        if (ClientScreenHandler.shouldDrawWorldBackground()) {
            drawFunction.accept(tint);
        }
        ClientScreenHandler.drawDarkBackground(this.getGuiScreen(), tint);
    }

    default public void updateGuiArea(Rectangle area) {
        GuiScreen guiScreen = this.getGuiScreen();
        if (guiScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)guiScreen;
            ClientScreenHandler.updateGuiArea(container, area);
        }
    }

    @ApiStatus.NonExtendable
    default public boolean isGuiContainer() {
        return this.getGuiScreen() instanceof GuiContainer;
    }

    @ApiStatus.NonExtendable
    default public void setHoveredSlot(Slot slot) {
        GuiScreen guiScreen = this.getGuiScreen();
        if (guiScreen instanceof GuiContainerAccessor) {
            GuiContainerAccessor acc = (GuiContainerAccessor)guiScreen;
            acc.setHoveredSlot(slot);
        }
    }

    default public GuiScreen getGuiScreen() {
        return (GuiScreen)this;
    }
}

