/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.widget;

import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.StackInfo;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.fluid.IOverflowableTank;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_FluidDisplayItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public interface FluidInteractionUtil {
    default public FluidStack getFluidForRealItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidForFilledItem((ItemStack)itemStack, (boolean)true);
        }
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (fluidStack == null && itemStack.func_77973_b() instanceof IFluidContainerItem) {
            fluidStack = ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack);
        }
        return fluidStack;
    }

    default public FluidStack getFluidForPhantomItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidFromContainerOrFluidDisplay((ItemStack)itemStack);
        }
        return StackInfo.getFluid((ItemStack)itemStack);
    }

    default public ItemStack fillFluidContainer(FluidStack fluidStack, ItemStack itemStack) {
        ItemStack filledContainer = this.fillFluidContainerWithoutIFluidContainerItem(fluidStack, itemStack);
        if (filledContainer == null) {
            filledContainer = this.fillFluidContainerWithIFluidContainerItem(fluidStack, itemStack);
        }
        return filledContainer;
    }

    default public ItemStack fillFluidContainerWithoutIFluidContainerItem(FluidStack fluidStack, ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack, (boolean)true, (boolean)false);
        }
        return null;
    }

    default public ItemStack fillFluidContainerWithIFluidContainerItem(FluidStack fluidStack, ItemStack itemStack) {
        IFluidContainerItem tContainerItem;
        int tFilledAmount;
        if (itemStack.func_77973_b() instanceof IFluidContainerItem && (tFilledAmount = (tContainerItem = (IFluidContainerItem)itemStack.func_77973_b()).fill(itemStack, fluidStack, true)) > 0) {
            fluidStack.amount -= tFilledAmount;
            return itemStack;
        }
        return null;
    }

    default public ItemStack getContainerForFilledItemWithoutIFluidContainerItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getContainerForFilledItem((ItemStack)itemStack, (boolean)false);
        }
        return null;
    }

    default public void addFluidNameInfo(List<Text> tooltip, @NotNull FluidStack fluid) {
        String formula;
        tooltip.add(new Text(fluid.getLocalizedName()).format(EnumChatFormatting.WHITE));
        if (ModularUI.isGT5ULoaded && !(formula = GT_FluidDisplayItem.getChemicalFormula((FluidStack)fluid)).isEmpty()) {
            tooltip.add(new Text(formula).format(EnumChatFormatting.YELLOW));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip.add(Text.localised("modularui.fluid.registry", fluid.getFluid().getName()));
            if (Interactable.hasShiftDown()) {
                tooltip.add(Text.localised("modularui.fluid.unique_registry", FluidRegistry.getDefaultFluidName((Fluid)fluid.getFluid())));
            }
        }
    }

    default public void addAdditionalFluidInfo(List<Text> tooltipContainer, @NotNull FluidStack fluid) {
        if (Interactable.hasShiftDown()) {
            tooltipContainer.add(Text.localised("modularui.fluid.temperature", fluid.getFluid().getTemperature(fluid)));
            tooltipContainer.add(Text.localised("modularui.fluid.state", fluid.getFluid().isGaseous(fluid) ? StatCollector.func_74838_a((String)"modularui.fluid.gas") : StatCollector.func_74838_a((String)"modularui.fluid.liquid")));
            String amountDetail = GuiContainerManager.fluidAmountDetails((FluidStack)fluid);
            if (amountDetail != null) {
                tooltipContainer.add(new Text(amountDetail).format(EnumChatFormatting.GRAY));
            }
        }
    }

    default public int getRealCapacity(IFluidTank fluidTank) {
        if (fluidTank instanceof IOverflowableTank) {
            return ((IOverflowableTank)fluidTank).getRealCapacity();
        }
        return fluidTank.getCapacity();
    }
}

