/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.FluidInteractionUtil;
import com.gtnewhorizons.modularui.api.widget.IDragAndDropHandler;
import com.gtnewhorizons.modularui.api.widget.IHasStackUnderMouse;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import gregtech.api.util.GT_Utility;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidNameHolderWidget
extends SyncedWidget
implements Interactable,
IDragAndDropHandler,
IHasStackUnderMouse,
FluidInteractionUtil {
    public static final Size SIZE = new Size(18, 18);
    private static final int PACKET_SYNC = 1;
    private static final int PACKET_CLICK = 2;
    private static final int PACKET_DND = 3;
    private final Supplier<String> getter;
    private final Consumer<String> setter;
    private String lastFluid;
    private boolean lastShift = false;

    public FluidNameHolderWidget(Supplier<String> getter, Consumer<String> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public void draw(float partialTicks) {
        FluidStack fluid = this.createFluidStack();
        if (fluid == null) {
            return;
        }
        Size size = this.getSize();
        GuiHelper.drawFluidTexture(new FluidStack(fluid, 0), 0.0f, 0.0f, size.width, size.height, 0.0f);
    }

    @Override
    public void buildTooltip(List<Text> tooltip) {
        super.buildTooltip(tooltip);
        FluidStack fluid = this.createFluidStack();
        if (fluid != null) {
            this.addFluidNameInfo(tooltip, fluid);
            this.addAdditionalFluidInfo(tooltip, fluid);
            tooltip.add(Text.localised("modularui.phantom.single.clear", new Object[0]));
            if (!Interactable.hasShiftDown()) {
                tooltip.add(Text.EMPTY);
                tooltip.add(Text.localised("modularui.tooltip.shift", new Object[0]));
            }
        } else {
            tooltip.add(Text.localised("modularui.fluid.none", new Object[0]).format(EnumChatFormatting.WHITE));
        }
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return SIZE;
    }

    @Override
    public void onScreenUpdate() {
        if (this.lastShift != Interactable.hasShiftDown()) {
            this.lastShift = Interactable.hasShiftDown();
            this.notifyTooltipChange();
        }
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        Widget.ClickData clickData = Widget.ClickData.create(buttonId, doubleClick);
        ItemStack cursorStack = this.getContext().getCursor().getItemStack();
        this.setFluidName(clickData, cursorStack);
        this.syncToServer(2, clickData::writeToPacket);
        return Interactable.ClickResult.ACCEPT;
    }

    @Override
    public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
        Widget.ClickData clickData = Widget.ClickData.create(button, false);
        this.setFluidName(clickData, draggedStack);
        this.syncToServer(3, buffer -> {
            clickData.writeToPacket((PacketBuffer)buffer);
            NetworkUtils.writeItemStack(buffer, draggedStack);
        });
        draggedStack.field_77994_a = 0;
        return true;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.setter.accept(NetworkUtils.readStringSafe(buf));
            this.notifyTooltipChange();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 2) {
            this.setFluidName(Widget.ClickData.readPacket(buf), this.getContext().getCursor().getItemStack());
        } else if (id == 3) {
            this.setFluidName(Widget.ClickData.readPacket(buf), NetworkUtils.readItemStack(buf));
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        String newFluid = this.getter.get();
        if (init || !Objects.equals(this.lastFluid, newFluid)) {
            this.lastFluid = newFluid;
            this.syncToClient(1, buffer -> NetworkUtils.writeStringSafe(buffer, this.lastFluid));
        }
    }

    private void setFluidName(Widget.ClickData clickData, ItemStack stack) {
        if (stack == null) {
            if (clickData.mouseButton != 0) {
                return;
            }
            this.setter.accept(null);
        } else {
            FluidStack fluid = this.getFluidForPhantomItem(stack);
            if (fluid == null || fluid.getFluid() == null) {
                return;
            }
            this.setter.accept(fluid.getFluid().getName());
        }
        this.notifyTooltipChange();
    }

    protected FluidStack createFluidStack() {
        String fluidName = this.getter.get();
        if (fluidName == null) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, 0);
    }

    @Override
    public ItemStack getStackUnderMouse() {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidDisplayStack((FluidStack)this.createFluidStack(), (boolean)false);
        }
        return null;
    }
}

