/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.animation;

import com.gtnewhorizons.modularui.api.animation.IEase;
import java.util.function.Consumer;

public class Interpolator {
    private final float from;
    private final float to;
    private final int duration;
    private final IEase ease;
    private final Consumer<Number> interpolate;
    private Consumer<Number> callback;
    private int runs = 0;
    private int progress = 0;

    public Interpolator(float from, float to, int duration, IEase ease, Consumer<Number> interpolate) {
        this(from, to, duration, ease, interpolate, null);
    }

    public Interpolator(float from, float to, int duration, IEase ease, Consumer<Number> interpolate, Consumer<Number> callback) {
        this.from = from;
        this.to = to;
        this.duration = duration;
        this.ease = ease;
        this.interpolate = interpolate;
        this.callback = callback;
    }

    public Interpolator getReversed(int duration, IEase ease) {
        return new Interpolator(this.to, this.from, duration, ease, this.interpolate, this.callback);
    }

    public void setCallback(Consumer<Number> callback) {
        this.callback = callback;
    }

    public void stop() {
        this.runs = 0;
    }

    public Interpolator forward() {
        this.progress = 0;
        this.runs = 1;
        return this;
    }

    public void backwards() {
        this.progress = this.duration;
        this.runs = -1;
    }

    public boolean isAtStart() {
        return this.progress == 0;
    }

    public boolean isAtEnd() {
        return this.progress >= this.duration;
    }

    public boolean isRunning() {
        return this.runs != 0 && this.progress > 0 && this.progress < this.duration;
    }

    public void update(float partialTicks) {
        if (this.runs != 0) {
            if (this.runs == -1 && this.progress <= 0) {
                this.progress = 0;
                if (this.callback != null) {
                    this.callback.accept(Float.valueOf(this.ease.interpolate((float)this.progress * 1.0f / (float)this.duration) * (this.to - this.from) + this.from));
                }
                this.stop();
                return;
            }
            if (this.runs == 1 && this.progress >= this.duration) {
                this.progress = this.duration;
                if (this.callback != null) {
                    this.callback.accept(Float.valueOf(this.ease.interpolate((float)this.progress * 1.0f / (float)this.duration) * (this.to - this.from) + this.from));
                }
                this.stop();
                return;
            }
            this.interpolate.accept(Float.valueOf(this.ease.interpolate((float)this.progress * 1.0f / (float)this.duration) * (this.to - this.from) + this.from));
            this.progress = (int)((float)this.progress + partialTicks * 50.0f * (float)this.runs);
        }
    }
}

