/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import java.util.function.BiConsumer;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends SyncedWidget
implements Interactable {
    private IDrawable[] hoveredBackground;
    private BiConsumer<Widget.ClickData, Widget> clickAction;
    private boolean playClickSound = true;

    public static ButtonWidget openSyncedWindowButton(int id) {
        return (ButtonWidget)new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(id);
            }
        }).setBackground(ModularUITextures.VANILLA_BACKGROUND, new Text("Window"));
    }

    public static ButtonWidget closeWindowButton(boolean syncedWindow) {
        return (ButtonWidget)new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!syncedWindow || !widget.isClient()) {
                widget.getWindow().closeWindow();
            }
        }).setBackground(ModularUITextures.VANILLA_BACKGROUND, new Text("x")).setSize(12, 12);
    }

    public ButtonWidget setOnClick(BiConsumer<Widget.ClickData, Widget> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public ButtonWidget setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
        return this;
    }

    public ButtonWidget setHoveredBackground(IDrawable ... hoveredBackground) {
        this.hoveredBackground = hoveredBackground;
        return this;
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return new Size(20, 20);
    }

    @Override
    @Nullable
    public IDrawable[] getBackground() {
        if (this.hoveredBackground != null && this.isHovering()) {
            return this.hoveredBackground;
        }
        return super.getBackground();
    }

    @Override
    @Nullable
    public String getBackgroundColorKey() {
        return "button";
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (this.clickAction != null) {
            Widget.ClickData clickData = Widget.ClickData.create(buttonId, doubleClick);
            this.clickAction.accept(clickData, this);
            if (this.syncsToServer()) {
                this.syncToServer(1, clickData::writeToPacket);
            }
            if (this.playClickSound) {
                Interactable.playButtonClickSound();
            }
            return Interactable.ClickResult.ACCEPT;
        }
        return Interactable.ClickResult.ACKNOWLEDGED;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 1) {
            Widget.ClickData data = Widget.ClickData.readPacket(buf);
            this.clickAction.accept(data, this);
            this.markForUpdate();
        }
    }
}

