/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal.wrapper;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.InvWrapper;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.forge.RangedWrapper;
import com.gtnewhorizons.modularui.api.forge.SlotItemHandler;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BaseSlot
extends SlotItemHandler {
    protected final boolean phantom;
    protected boolean canInsert = true;
    protected boolean canTake = true;
    private ISyncedWidget parentWidget;
    protected boolean enabled = true;
    private int shiftClickPriority = 0;
    private boolean ignoreStackSizeLimit = false;
    private Runnable changeListener;
    private Predicate<ItemStack> filter;
    private ItemStack cachedItem = null;
    private boolean needsSyncing;
    private static final IItemHandlerModifiable EMPTY = new ItemStackHandler();

    public static BaseSlot phantom() {
        return BaseSlot.phantom(new ItemStackHandler(), 0);
    }

    public static BaseSlot phantom(IItemHandlerModifiable handler, int index) {
        return new BaseSlot(handler, index, true);
    }

    public static BaseSlot empty() {
        return new BaseSlot(EMPTY, 0, true);
    }

    public BaseSlot(IItemHandlerModifiable inventory, int index) {
        this(inventory, index, false);
    }

    public BaseSlot(IItemHandlerModifiable inventory, int index, boolean phantom) {
        super(inventory, index, 0, 0);
        this.phantom = phantom;
        if (this.phantom) {
            this.shiftClickPriority += 10;
        }
    }

    public BaseSlot setShiftClickPriority(int shiftClickPriority) {
        this.shiftClickPriority = shiftClickPriority;
        return this;
    }

    public BaseSlot disableShiftInsert() {
        return this.setShiftClickPriority(Integer.MIN_VALUE);
    }

    public BaseSlot setAccess(boolean canTake, boolean canInsert) {
        this.canTake = canTake;
        this.canInsert = canInsert;
        return this;
    }

    public BaseSlot setIgnoreStackSizeLimit(boolean ignoreStackSizeLimit) {
        this.ignoreStackSizeLimit = ignoreStackSizeLimit;
        return this;
    }

    public BaseSlot setParentWidget(ISyncedWidget parentWidget) {
        this.parentWidget = parentWidget;
        return this;
    }

    public ISyncedWidget getParentWidget() {
        return this.parentWidget;
    }

    @Override
    public boolean func_75214_a(@NotNull ItemStack stack) {
        return !this.phantom && this.isItemValidPhantom(stack);
    }

    public boolean isItemValidPhantom(ItemStack stack) {
        return this.canInsert && (this.filter == null || this.filter.test(stack)) && this.getItemHandler().isItemValid(this.getSlotIndex(), stack);
    }

    @Override
    public boolean func_82869_a(EntityPlayer playerIn) {
        return !this.phantom && this.canTake && this.isEnabled() && super.func_82869_a(playerIn);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean func_111238_b() {
        return this.isEnabled();
    }

    public boolean isCanInsert() {
        return this.canInsert;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public boolean isIgnoreStackSizeLimit() {
        return this.ignoreStackSizeLimit;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getShiftClickPriority() {
        return this.shiftClickPriority;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void setFilter(Predicate<ItemStack> filter) {
        this.filter = filter;
    }

    public void func_75218_e() {
        if (this.func_75211_c() != null) {
            this.cachedItem = this.func_75211_c().func_77946_l();
        }
        this.needsSyncing = true;
        if (this.changeListener != null) {
            this.changeListener.run();
        }
        if (this.parentWidget == null) {
            throw new IllegalStateException("BaseSlot does not have parent widget to mark for update!");
        }
        this.parentWidget.markForUpdate();
    }

    public boolean func_75217_a(IInventory inventory, int index) {
        IItemHandlerModifiable itemHandler;
        if (this.getItemHandler() instanceof RangedWrapper && (itemHandler = ((RangedWrapper)this.getItemHandler()).getCompose()) instanceof InvWrapper) {
            return ((InvWrapper)itemHandler).getInv() == inventory && index == this.getSlotIndex();
        }
        return super.func_75217_a(inventory, index);
    }

    public boolean isNeedsSyncing() {
        return this.needsSyncing;
    }

    public void resetNeedsSyncing() {
        this.needsSyncing = false;
    }

    public ResourceLocation getBackgroundIconTexture() {
        return null;
    }

    public void incrementStackCount(int amount) {
        ItemStack stack = this.func_75211_c();
        if (stack == null) {
            return;
        }
        int oldAmount = stack.field_77994_a;
        if (amount < 0) {
            amount = Math.max(0, oldAmount + amount);
        } else if (this.parentWidget instanceof SlotWidget && !((SlotWidget)this.parentWidget).canControlAmount()) {
            amount = 1;
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            int maxSize = this.getItemHandler().getSlotLimit(this.getSlotIndex());
            if (!this.isIgnoreStackSizeLimit() && stack.func_77976_d() < maxSize) {
                maxSize = stack.func_77976_d();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack.field_77994_a = amount;
            if (stack.field_77994_a < 1) {
                this.func_75215_d(null);
            } else {
                this.func_75218_e();
            }
        }
    }
}

