/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class NumberFormat {
    private static final NavigableMap<Double, String> suffixesByPower = new TreeMap<Double, String>();
    private static final java.text.NumberFormat[] NUMBER_FORMAT = new java.text.NumberFormat[]{new DecimalFormat("0."), new DecimalFormat("0.#"), new DecimalFormat("0.##"), new DecimalFormat("0.###"), new DecimalFormat("0.####"), new DecimalFormat("0.#####"), new DecimalFormat("0.######"), new DecimalFormat("0.#######"), new DecimalFormat("0.########"), new DecimalFormat("0.#########")};

    @NotNull
    public static String format(double value, int precision) {
        String suffix;
        double divideBy;
        if (value == Double.MIN_VALUE) {
            return NumberFormat.format(1.0, precision);
        }
        if (value == 0.0) {
            return "0";
        }
        if (value < 0.0) {
            return '-' + NumberFormat.format(-value, precision);
        }
        if (value < (double)NumberFormat.pow(10, precision)) {
            divideBy = 1.0;
            suffix = "";
        } else {
            Map.Entry<Double, String> e = suffixesByPower.floorEntry(value);
            divideBy = e.getKey();
            suffix = e.getValue();
        }
        double truncated = value / (divideBy / 10.0);
        boolean hasDecimal = truncated < 100.0 && truncated / 10.0 != truncated / 10.0;
        return hasDecimal ? NUMBER_FORMAT[precision].format(truncated / 10.0) + suffix : NUMBER_FORMAT[precision].format(truncated / 10.0) + suffix;
    }

    @NotNull
    public static String format(double value) {
        return NumberFormat.format(value, 3);
    }

    private static int pow(int num, int e) {
        int result = num;
        for (int i = 0; i < e; ++i) {
            result *= num;
        }
        return result;
    }

    static {
        suffixesByPower.put(1.0E-18, "a");
        suffixesByPower.put(1.0E-15, "f");
        suffixesByPower.put(1.0E-12, "p");
        suffixesByPower.put(1.0E-9, "n");
        suffixesByPower.put(1.0E-6, "u");
        suffixesByPower.put(0.001, "m");
        suffixesByPower.put(1000.0, "k");
        suffixesByPower.put(1000000.0, "M");
        suffixesByPower.put(1.0E9, "G");
        suffixesByPower.put(1.0E12, "T");
        suffixesByPower.put(1.0E15, "P");
        suffixesByPower.put(1.0E18, "E");
    }
}

