/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.savedata;

import com.kuba6000.mobsinfo.api.utils.ModUtils;
import com.kuba6000.mobsinfo.savedata.PlayerData;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;

public class PlayerDataManager
extends WorldSavedData {
    private static final String playerDataName = "mobsinfo_playerdata";
    static PlayerDataManager Instance = null;
    private final HashMap<UUID, PlayerData> players = new HashMap();
    private static PlayerData localPlayerData = new PlayerData();

    public static void Initialize(World world) {
        if (Instance != null) {
            PlayerDataManager.Instance.players.clear();
        }
        if ((Instance = (PlayerDataManager)world.field_72988_C.func_75742_a(PlayerDataManager.class, playerDataName)) == null) {
            Instance = new PlayerDataManager();
            world.field_72988_C.func_75745_a(playerDataName, (WorldSavedData)Instance);
        }
        Instance.func_76185_a();
    }

    public PlayerDataManager(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public PlayerDataManager() {
        super(playerDataName);
    }

    public void func_76184_a(NBTTagCompound NBTData) {
        if (!NBTData.func_150297_b("players", 9)) {
            return;
        }
        this.players.clear();
        NBTTagList list = NBTData.func_150295_c("players", 10);
        int imax = list.func_74745_c();
        for (int i = 0; i < imax; ++i) {
            NBTTagCompound playerNBTData = list.func_150305_b(i);
            if (!playerNBTData.func_74764_b("uuid")) continue;
            UUID uuid = UUID.fromString(playerNBTData.func_74779_i("uuid"));
            PlayerData pData = new PlayerData(playerNBTData.func_74775_l("data"));
            this.players.put(uuid, pData);
        }
    }

    public void func_76187_b(NBTTagCompound NBTData) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, PlayerData> playerDataEntry : this.players.entrySet()) {
            NBTTagCompound playerNBTData = new NBTTagCompound();
            playerNBTData.func_74778_a("uuid", playerDataEntry.getKey().toString());
            playerNBTData.func_74782_a("data", (NBTBase)playerDataEntry.getValue().toNBTData());
            list.func_74742_a((NBTBase)playerNBTData);
        }
        NBTData.func_74782_a("players", (NBTBase)list);
    }

    public static PlayerData getPlayer(EntityPlayer player) {
        if (ModUtils.isClientThreaded()) {
            return localPlayerData;
        }
        UUID uuid = player.getPersistentID();
        if (!PlayerDataManager.Instance.players.containsKey(uuid)) {
            PlayerData pData = new PlayerData();
            PlayerDataManager.Instance.players.put(uuid, pData);
            Instance.func_76185_a();
            return pData;
        }
        return PlayerDataManager.Instance.players.get(uuid);
    }

    public void func_76185_a() {
        super.func_76185_a();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K || event.world.field_73011_w.field_76574_g != 0) {
            return;
        }
        PlayerDataManager.Initialize(event.world);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SyncToClient {
    }
}

