/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.uplink;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.util.item.AEFluidStack;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.recursive_pineapple.matter_manipulator.common.items.MMItemList;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.networking.Messages;
import com.recursive_pineapple.matter_manipulator.common.structure.CasingGTFrames;
import com.recursive_pineapple.matter_manipulator.common.structure.MMCasings;
import com.recursive_pineapple.matter_manipulator.common.uplink.IUplinkMulti;
import com.recursive_pineapple.matter_manipulator.common.uplink.MTEMMUplinkMEHatch;
import com.recursive_pineapple.matter_manipulator.common.uplink.Structures;
import com.recursive_pineapple.matter_manipulator.common.uplink.UplinkState;
import com.recursive_pineapple.matter_manipulator.common.uplink.UplinkStatus;
import com.recursive_pineapple.matter_manipulator.common.utils.BigFluidStack;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.casing.ICasing;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.structure.StructureWrapperInstanceInfo;
import gregtech.api.structure.StructureWrapperTooltipBuilder;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;

public class MTEMMUplink
extends MTEExtendedPowerMultiBlockBase<MTEMMUplink>
implements ISurvivalConstructable,
IUplinkMulti,
IStructureProvider<MTEMMUplink> {
    private static final long BASE_PLASMA_EU_COST = 131072L;
    private long pendingPlasmaEU = 0L;
    private long address = 0L;
    private final ArrayList<MTEMMUplinkMEHatch> uplinkHatches = new ArrayList();
    protected final StructureWrapper<MTEMMUplink> structure;
    protected final StructureWrapperInstanceInfo<MTEMMUplink> structureInstanceInfo;
    private static CasingGTFrames TRINIUM_FRAMES;
    private static CasingGTFrames NAQ_ALLOY_FRAMES;
    private static final Textures.BlockIcons.CustomIcon ACTIVE_GLOW;
    private static final Textures.BlockIcons.CustomIcon IDLE_GLOW;
    private static final Textures.BlockIcons.CustomIcon OFF;
    @SideOnly(value=Side.CLIENT)
    private UplinkState state;
    private static final Function<MTEHatchInputME, FluidStack[]> ME_HATCH_STORED_FLUIDS;
    private UplinkState lastState;
    private int stateCounter = 0;

    public MTEMMUplink(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        TRINIUM_FRAMES = CasingGTFrames.forMaterial(Materials.Trinium);
        NAQ_ALLOY_FRAMES = CasingGTFrames.forMaterial(Materials.NaquadahAlloy);
        this.structure = new StructureWrapper((IStructureProvider)this);
        this.structureInstanceInfo = null;
        this.structure.loadStructure();
    }

    protected MTEMMUplink(MTEMMUplink prototype) {
        super(prototype.mName);
        this.structure = prototype.structure;
        this.structureInstanceInfo = new StructureWrapperInstanceInfo(this.structure);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMMUplink(this);
    }

    public String[][] getDefinition() {
        return Structures.UPLINK;
    }

    public IStructureInstance<MTEMMUplink> getStructureInstance() {
        return this.structureInstanceInfo;
    }

    public IStructureDefinition<MTEMMUplink> compile(String[][] definition) {
        this.structure.addCasing('A', (ICasing)MMCasings.AdvancedIridiumPlatedMachineCasing).withHatches(1, 16, Arrays.asList(new IHatchElement[]{HatchElement.InputHatch, HatchElement.Energy, HatchElement.ExoticEnergy, HatchElement.Maintenance, UplinkHatchAdder.INSTANCE}));
        this.structure.addCasing('B', (ICasing)NAQ_ALLOY_FRAMES);
        this.structure.addCasing('C', (ICasing)TRINIUM_FRAMES);
        this.structure.addCasing('D', (ICasing)MMCasings.MatterGenerationCoil);
        this.structure.addCasing('E', (ICasing)MMCasings.RadiantNaquadahAlloyCasing);
        return this.structure.buildStructure(definition);
    }

    public IStructureDefinition<MTEMMUplink> getStructureDefinition() {
        return this.structure.structureDefinition;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structure.construct((MTEMultiBlockBase)this, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.structure.survivalConstruct((MTEMultiBlockBase)this, stackSize, elementBudget, env);
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structure.checkStructure((MTEMultiBlockBase)this);
    }

    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        this.structureInstanceInfo.validate(errors, context);
    }

    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        this.structureInstanceInfo.localizeStructureErrors(errors, context, lines);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        StructureWrapperTooltipBuilder tt = new StructureWrapperTooltipBuilder(this.structure);
        String hatch = MMItemList.UplinkHatch.get(1).func_82833_r();
        tt.addMachineType("Matter Manipulator Quantum Uplink").addInfo("Interdimensional and infinite range uplink for matter manipulators.").addInfo("Allows manipulators to convert plans into AE patterns.").addInfo("Connects directly to an ME system via a " + EnumChatFormatting.GOLD + hatch + EnumChatFormatting.GRAY + ".").addSeparator().addInfo("Consumes 1A ZPM while active.").addInfo("Must be fed with plasma via an input hatch.").addInfo("Transfers to/from the manipulator cost " + String.format("%,d", 131072L) + " EU in plasma per item or per bucket.").addInfo("Insert a compatible manipulator in the controller slot while the machine is running to bind it to the uplink.");
        tt.beginStructureBlock();
        tt.addController("Front Center");
        tt.addHatchNameOverride((IHatchElement)UplinkHatchAdder.INSTANCE, hatch);
        tt.addAllCasingInfo(Arrays.asList(new ICasing[]{MMCasings.AdvancedIridiumPlatedMachineCasing, MMCasings.MatterGenerationCoil, TRINIUM_FRAMES, NAQ_ALLOY_FRAMES, MMCasings.RadiantNaquadahAlloyCasing}), null);
        tt.toolTipFinisher(new String[]{GTValues.AuthorPineapple});
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        ArrayList<ITexture> textures = new ArrayList<ITexture>(3);
        textures.add(MMCasings.AdvancedIridiumPlatedMachineCasing.getCasingTexture());
        if (side == facing) {
            textures.add(TextureFactory.builder().addIcon((IIconContainer)OFF).extFacing().build());
            switch (this.getState()) {
                case OFF: {
                    break;
                }
                case IDLE: {
                    textures.add(TextureFactory.builder().addIcon((IIconContainer)IDLE_GLOW).extFacing().glow().build());
                    break;
                }
                case ACTIVE: {
                    textures.add(TextureFactory.builder().addIcon((IIconContainer)ACTIVE_GLOW).extFacing().glow().build());
                }
            }
        }
        return textures.toArray(new ITexture[0]);
    }

    @Override
    public UplinkState getState() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.getBaseMetaTileEntity().isActive()) {
                if (this.uplinkHatches.stream().anyMatch(hatch -> hatch.hasAnyRequests())) {
                    return UplinkState.ACTIVE;
                }
                return UplinkState.IDLE;
            }
            return UplinkState.OFF;
        }
        if (this.state == null) {
            this.state = UplinkState.OFF;
        }
        return this.state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(UplinkState state) {
        this.state = state;
        this.getBaseMetaTileEntity().issueTextureUpdate();
    }

    @Override
    public Location getLocation() {
        IGregTechTileEntity igte = this.getBaseMetaTileEntity();
        if (igte != null) {
            return new Location(igte.getWorld(), igte.getXCoord(), (int)igte.getYCoord(), igte.getZCoord());
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.getBaseMetaTileEntity() != null && this.getBaseMetaTileEntity().isActive();
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.address = aNBT.func_74763_f("address");
        this.pendingPlasmaEU = aNBT.func_74763_f("plasmaEU");
        if (this.address == 0L) {
            this.address = MTEMMUplink.newAddress();
        }
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        currentTip.add(String.format("Address: %x", accessor.getNBTData().func_74763_f("address")));
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("address", this.address);
    }

    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        super.addAdditionalTooltipInformation(stack, tooltip);
        if (stack.func_77978_p() != null) {
            tooltip.add(String.format("Address: %x", stack.func_77978_p().func_74763_f("address")));
        }
    }

    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(String.format("Stored Plasma: %s%,d%s EU", EnumChatFormatting.YELLOW, this.pendingPlasmaEU, EnumChatFormatting.WHITE));
        return info.toArray(new String[0]);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("address", this.address);
        aNBT.func_74772_a("plasmaEU", this.pendingPlasmaEU);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        aNBT.func_74772_a("address", this.address);
    }

    public void initDefaultModes(NBTTagCompound aNBT) {
        this.address = aNBT == null ? MTEMMUplink.newAddress() : aNBT.func_74763_f("address");
    }

    private static long newAddress() {
        return (long)(9.223372036854776E18 * Math.random());
    }

    private MTEMMUplinkMEHatch getMEHatch() {
        for (MTEMMUplinkMEHatch hatch : this.uplinkHatches) {
            if (hatch == null || !hatch.isActive() || !hatch.isPowered()) continue;
            return hatch;
        }
        return null;
    }

    @Override
    public Pair<UplinkStatus, List<BigItemStack>> tryConsumeItems(List<BigItemStack> requestedItems, boolean simulate, boolean fuzzy) {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch == null) {
            return Pair.of((Object)((Object)UplinkStatus.NO_HATCH), null);
        }
        IStorageGrid storage = hatch.getStorageGrid();
        if (storage == null) {
            return Pair.of((Object)((Object)UplinkStatus.AE_OFFLINE), null);
        }
        IMEMonitor itemInventory = storage.getItemInventory();
        if (itemInventory == null) {
            return Pair.of((Object)((Object)UplinkStatus.AE_OFFLINE), null);
        }
        ArrayList<BigItemStack> out = new ArrayList<BigItemStack>();
        block0: for (BigItemStack req : requestedItems) {
            if (req.getStackSize() == 0L) continue;
            ImmutableList matches = fuzzy ? ImmutableList.copyOf((Collection)itemInventory.getStorageList().findFuzzy((IAEStack)req.getAEItemStack(), FuzzyMode.IGNORE_ALL)) : Arrays.asList((IAEItemStack)itemInventory.getStorageList().findPrecise((IAEStack)req.getAEItemStack()));
            for (IAEItemStack match : matches) {
                if (req.getStackSize() == 0L) continue block0;
                if (match == null || match.getStackSize() == 0L) continue;
                match = (IAEItemStack)match.copy().setStackSize(req.getStackSize());
                if (!simulate && !this.consumePlasmaEU(req.getStackSize() * 131072L)) {
                    return Pair.of((Object)((Object)UplinkStatus.NO_PLASMA), null);
                }
                IAEItemStack result = (IAEItemStack)itemInventory.extractItems((IAEStack)match, simulate ? Actionable.SIMULATE : Actionable.MODULATE, hatch.getRequestSource());
                if (result == null) continue;
                out.add(BigItemStack.create(result));
                req.setStackSize(req.getStackSize() - result.getStackSize());
            }
        }
        return Pair.of((Object)((Object)UplinkStatus.OK), out);
    }

    @Override
    public UplinkStatus tryGivePlayerItems(List<BigItemStack> items) {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch == null) {
            return UplinkStatus.NO_HATCH;
        }
        IStorageGrid storage = hatch.getStorageGrid();
        if (storage == null) {
            return UplinkStatus.AE_OFFLINE;
        }
        IMEMonitor itemInventory = storage.getItemInventory();
        if (itemInventory == null) {
            return UplinkStatus.AE_OFFLINE;
        }
        for (BigItemStack item : items) {
            if (item == null) continue;
            if (!this.consumePlasmaEU(item.getStackSize() * 131072L)) {
                return UplinkStatus.NO_PLASMA;
            }
            IAEItemStack result = (IAEItemStack)itemInventory.injectItems((IAEStack)item.getAEItemStack(), Actionable.MODULATE, hatch.getRequestSource());
            item.setStackSize(result == null ? 0L : result.getStackSize());
        }
        return UplinkStatus.OK;
    }

    @Override
    public UplinkStatus tryGivePlayerFluids(List<BigFluidStack> fluids) {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch == null) {
            return UplinkStatus.NO_HATCH;
        }
        IStorageGrid storage = hatch.getStorageGrid();
        if (storage == null) {
            return UplinkStatus.AE_OFFLINE;
        }
        IMEMonitor fluidInventory = storage.getFluidInventory();
        if (fluidInventory == null) {
            return UplinkStatus.AE_OFFLINE;
        }
        for (BigFluidStack fluid : fluids) {
            if (fluid == null) continue;
            if (!this.consumePlasmaEU(MMUtils.ceilDiv(fluid.getStackSize(), 1000L) * 131072L)) {
                return UplinkStatus.NO_PLASMA;
            }
            IAEFluidStack result = (IAEFluidStack)fluidInventory.injectItems((IAEStack)fluid.getAEFluidStack(), Actionable.MODULATE, hatch.getRequestSource());
            fluid.setStackSize(result == null ? 0L : result.getStackSize());
        }
        return UplinkStatus.OK;
    }

    @Override
    public IStorageGrid getStorageGrid() {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch == null) {
            return null;
        }
        return hatch.getStorageGrid();
    }

    private boolean consumePlasmaEU(long euToConsume) {
        if (this.pendingPlasmaEU < euToConsume) {
            this.generatePlasmaEU(euToConsume - this.pendingPlasmaEU);
        }
        if (this.pendingPlasmaEU >= euToConsume) {
            this.pendingPlasmaEU -= euToConsume;
            return true;
        }
        return false;
    }

    private void generatePlasmaEU(long euToGenerate) {
        FuelBackend fuels = (FuelBackend)RecipeMaps.plasmaFuels.getBackend();
        for (MTEHatchInput input : this.mInputHatches) {
            if (input instanceof MTEHatchInputME) {
                MTEHatchInputME me = (MTEHatchInputME)input;
                try {
                    FluidStack[] fluids;
                    IMEMonitor inv = me.getProxy().getStorage().getFluidInventory();
                    IEnergyGrid energy = me.getProxy().getEnergy();
                    for (FluidStack fluid : fluids = ME_HATCH_STORED_FLUIDS.apply(me)) {
                        if (fluid == null) continue;
                        GTRecipe fuel = fuels.findFuel(fluid);
                        if (fuel != null) {
                            long euPerLitre = fuel.mSpecialValue;
                            int litresToConsume = (int)Math.min(Integer.MAX_VALUE, MMUtils.ceilDiv(euToGenerate, euPerLitre));
                            FluidStack toConsume = fluid.copy();
                            toConsume.amount = litresToConsume;
                            IAEFluidStack drained = (IAEFluidStack)inv.extractItems((IAEStack)AEFluidStack.create((Object)toConsume), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)me.getBaseMetaTileEntity()));
                            if (drained == null) continue;
                            energy.extractAEPower((double)drained.getStackSize(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                            long generated = drained.getStackSize() * euPerLitre;
                            euToGenerate -= generated;
                            this.pendingPlasmaEU += generated;
                        }
                        if (euToGenerate > 0L) continue;
                        return;
                    }
                    continue;
                }
                catch (GridAccessException gridAccessException) {
                    continue;
                }
            }
            for (FluidTankInfo tank : input.getTankInfo(ForgeDirection.UNKNOWN)) {
                if (tank.fluid == null) continue;
                GTRecipe fuel = fuels.findFuel(tank.fluid);
                if (fuel != null) {
                    long euPerLitre = fuel.mSpecialValue;
                    int litresToConsume = (int)Math.min(Integer.MAX_VALUE, MMUtils.ceilDiv(euToGenerate, euPerLitre));
                    FluidStack toConsume = tank.fluid.copy();
                    toConsume.amount = litresToConsume;
                    FluidStack drained = input.drain(ForgeDirection.UNKNOWN, toConsume, true);
                    long generated = (long)drained.amount * euPerLitre;
                    euToGenerate -= generated;
                    this.pendingPlasmaEU += generated;
                }
                if (euToGenerate > 0L) continue;
                return;
            }
        }
    }

    @Override
    public void submitPlan(EntityPlayer submitter, String details, List<BigItemStack> requiredItems, boolean autocraft) {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch != null) {
            String patternName = String.format("%s's Manipulator Plan", submitter.func_146103_bH().getName());
            if (details != null && !details.isEmpty()) {
                patternName = patternName + " (" + details + ")";
            }
            hatch.addRequest(submitter, patternName, MMUtils.mapToList(requiredItems, BigItemStack::getAEItemStack), autocraft);
            MMUtils.sendInfoToPlayer(submitter, StatCollector.func_74837_a((String)"mm.info.new_virtual_me_pattern", (Object[])new Object[]{patternName}));
        }
    }

    @Override
    public void clearManualPlans(EntityPlayer player) {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch != null) {
            hatch.clearManualPlans(player);
        }
    }

    @Override
    public void cancelAutoPlans(EntityPlayer player) {
        MTEMMUplinkMEHatch hatch = this.getMEHatch();
        if (hatch != null) {
            hatch.cancelAutoPlans(player);
        }
    }

    @Override
    public double drainPower(double requested) {
        double drained = 0.0;
        for (MTEHatch hatch : (List)GTUtility.filterValidMTEs((Collection)this.mExoticEnergyHatches)) {
            if (!(hatch instanceof MTEHatchEnergyMulti)) continue;
            MTEHatchEnergyMulti exotic = (MTEHatchEnergyMulti)hatch;
            long toKeep = TierEU.RECIPE_ZPM * 20L * 5L;
            long extractable = exotic.getEUVar() - toKeep;
            if (extractable <= 0L) continue;
            long remaining = MMUtils.ceilLong(requested - drained);
            if (remaining <= 0L) break;
            extractable = Math.min(extractable, remaining);
            exotic.setEUVar(exotic.getEUVar() - extractable);
            drained += (double)extractable;
        }
        return drained;
    }

    public boolean onRunningTick(ItemStack aStack) {
        Item item;
        if (aStack != null && (item = aStack.func_77973_b()) instanceof ItemMatterManipulator) {
            ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
            manipulator.setUplinkAddress(aStack, this.address);
        }
        return super.onRunningTick(aStack);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 5L == 0L) {
            UplinkState state = this.getState();
            ++this.stateCounter;
            if (state != this.lastState || this.stateCounter > 10) {
                this.lastState = state;
                this.stateCounter = 0;
                this.sendUplinkStateUpdate();
            }
        }
    }

    @Nonnull
    public CheckRecipeResult checkProcessing() {
        this.mMaxProgresstime = 20;
        this.mEUt = (int)(-TierEU.RECIPE_ZPM);
        this.mEfficiency = 10000;
        UPLINKS.put(this.address, this);
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public void stopMachine(@Nonnull ShutDownReason reason) {
        super.stopMachine(reason);
        UPLINKS.remove(this.address);
        this.sendUplinkStateUpdate();
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        UPLINKS.remove(this.address);
    }

    private void sendUplinkStateUpdate() {
        IGregTechTileEntity igte = this.getBaseMetaTileEntity();
        if (igte != null) {
            Location l = new Location(igte.getWorld(), igte.getXCoord(), (int)igte.getYCoord(), igte.getZCoord());
            Messages.UpdateUplinkState.sendToPlayersAround(l, this);
        }
    }

    static {
        ACTIVE_GLOW = new Textures.BlockIcons.CustomIcon(Mods.MatterManipulator.getResourcePath("machines", "uplink", "OVERLAY_FRONT_ACTIVE_GLOW"));
        IDLE_GLOW = new Textures.BlockIcons.CustomIcon(Mods.MatterManipulator.getResourcePath("machines", "uplink", "OVERLAY_FRONT_IDLE_GLOW"));
        OFF = new Textures.BlockIcons.CustomIcon(Mods.MatterManipulator.getResourcePath("machines", "uplink", "OVERLAY_FRONT_OFF"));
        ME_HATCH_STORED_FLUIDS = MMUtils.exposeFieldGetterLambda(MTEHatchInputME.class, "storedFluids");
    }

    private static enum UplinkHatchAdder implements IHatchElement<MTEMMUplink>
    {
        INSTANCE;


        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Arrays.asList(MTEMMUplinkMEHatch.class);
        }

        public IGTHatchAdder<? super MTEMMUplink> adder() {
            return (uplink, hatchTE, aBaseCasingIndex) -> {
                if (hatchTE == null || hatchTE.isDead()) {
                    return false;
                }
                IMetaTileEntity aMetaTileEntity = hatchTE.getMetaTileEntity();
                if (aMetaTileEntity == null) {
                    return false;
                }
                if (!(aMetaTileEntity instanceof MTEMMUplinkMEHatch)) {
                    return false;
                }
                MTEMMUplinkMEHatch uplinkHatch = (MTEMMUplinkMEHatch)aMetaTileEntity;
                ((MTEMMUplink)uplink).uplinkHatches.add(uplinkHatch);
                uplinkHatch.updateTexture(aBaseCasingIndex.shortValue());
                uplinkHatch.updateCraftingIcon(uplink.getMachineCraftingIcon());
                return true;
            };
        }

        public long count(MTEMMUplink t) {
            return t.uplinkHatches.size();
        }
    }
}

