/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items;

import com.recursive_pineapple.matter_manipulator.common.items.MMUpgrades;
import com.recursive_pineapple.matter_manipulator.common.items.MetaItem;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import java.util.Objects;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeInstallUpgrade
implements IRecipe {
    public static final RecipeInstallUpgrade INSTANCE = new RecipeInstallUpgrade();

    public static void register() {
        CraftingManager.func_77594_a().func_77592_b().add(INSTANCE);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (RecipeInstallUpgrade.getItemCount(inv) > 2) {
            return false;
        }
        ManipulatorInfo manipulator = RecipeInstallUpgrade.findManipulator(inv);
        if (manipulator == null) {
            return false;
        }
        UpgradeInfo upgrade = RecipeInstallUpgrade.findUpgrade(inv, manipulator);
        return upgrade != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (RecipeInstallUpgrade.getItemCount(inv) > 2) {
            return null;
        }
        ManipulatorInfo manipulator = RecipeInstallUpgrade.findManipulator(inv);
        if (manipulator == null) {
            return null;
        }
        UpgradeInfo upgrade = RecipeInstallUpgrade.findUpgrade(inv, manipulator);
        if (upgrade == null) {
            return null;
        }
        ItemStack stack = manipulator.stack.func_77946_l();
        manipulator.state.installUpgrade(upgrade.upgrade);
        ItemMatterManipulator.setState(stack, manipulator.state);
        return stack;
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return null;
    }

    private static int getItemCount(InventoryCrafting inv) {
        int size = inv.func_70302_i_();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null) continue;
            ++count;
        }
        return count;
    }

    private static ManipulatorInfo findManipulator(InventoryCrafting inv) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            Item item;
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || !((item = stack.func_77973_b()) instanceof ItemMatterManipulator)) continue;
            ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
            return new ManipulatorInfo(stack, i, ItemMatterManipulator.getState(stack), manipulator.tier);
        }
        return null;
    }

    private static UpgradeInfo findUpgrade(InventoryCrafting inv, ManipulatorInfo manipulator) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            MMUpgrades upgrade;
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof MetaItem) || (upgrade = (MMUpgrades)((Object)MMUpgrades.UPGRADES_BY_META.get(stack.func_77960_j()))) == null || !manipulator.state.couldAcceptUpgrade(manipulator.tier, upgrade)) continue;
            return new UpgradeInfo(stack, i, upgrade);
        }
        return null;
    }

    private static final class ManipulatorInfo {
        private final ItemStack stack;
        private final int slot;
        private final MMState state;
        private final ItemMatterManipulator.ManipulatorTier tier;

        private ManipulatorInfo(ItemStack stack, int slot, MMState state, ItemMatterManipulator.ManipulatorTier tier) {
            this.stack = stack;
            this.slot = slot;
            this.state = state;
            this.tier = tier;
        }

        public String toString() {
            return "ManipulatorInfo[" + "stack=" + this.stack + "," + "slot=" + this.slot + "," + "state=" + this.state + "," + "tier=" + (Object)((Object)this.tier) + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.stack != null ? this.stack.hashCode() : 0);
            result = 31 * result + this.slot;
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((ManipulatorInfo)arg0).stack, this.stack)) {
                return false;
            }
            if (((ManipulatorInfo)arg0).slot != this.slot) {
                return false;
            }
            if (!Objects.equals(((ManipulatorInfo)arg0).state, this.state)) {
                return false;
            }
            return Objects.equals((Object)((ManipulatorInfo)arg0).tier, (Object)this.tier);
            {
            }
        }

        public ItemStack stack() {
            return this.stack;
        }

        public int slot() {
            return this.slot;
        }

        public MMState state() {
            return this.state;
        }

        public ItemMatterManipulator.ManipulatorTier tier() {
            return this.tier;
        }
    }

    private static final class UpgradeInfo {
        private final ItemStack stack;
        private final int slot;
        private final MMUpgrades upgrade;

        private UpgradeInfo(ItemStack stack, int slot, MMUpgrades upgrade) {
            this.stack = stack;
            this.slot = slot;
            this.upgrade = upgrade;
        }

        public String toString() {
            return "UpgradeInfo[" + "stack=" + this.stack + "," + "slot=" + this.slot + "," + "upgrade=" + (Object)((Object)this.upgrade) + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.stack != null ? this.stack.hashCode() : 0);
            result = 31 * result + this.slot;
            result = 31 * result + (this.upgrade != null ? this.upgrade.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((UpgradeInfo)arg0).stack, this.stack)) {
                return false;
            }
            if (((UpgradeInfo)arg0).slot != this.slot) {
                return false;
            }
            return Objects.equals((Object)((UpgradeInfo)arg0).upgrade, (Object)this.upgrade);
            {
            }
        }

        public ItemStack stack() {
            return this.stack;
        }

        public int slot() {
            return this.slot;
        }

        public MMUpgrades upgrade() {
            return this.upgrade;
        }
    }
}

