/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building.providers;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.definitions.IItemDefinition;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.parts.automation.UpgradeInventory;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.building.providers.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AECellItemProvider
implements IItemProvider {
    public PortableItemStack mCell;
    public PortableItemStack[] mUpgrades;
    public PortableItemStack[] mConfig;
    public String mOreDict;
    public byte mFuzzyMode;

    public static AECellItemProvider fromWorkbenchItem(ItemStack stack) {
        boolean hasOredictCard;
        int n;
        ICellWorkbenchItem item;
        Item item2;
        if (stack == null || !((item2 = stack.func_77973_b()) instanceof ICellWorkbenchItem) || !(item = (ICellWorkbenchItem)item2).isEditable(stack)) {
            return null;
        }
        AECellItemProvider cell = new AECellItemProvider();
        cell.mCell = new PortableItemStack(stack);
        IInventory upgrades = item.getUpgradesInventory(stack);
        cell.mUpgrades = upgrades == null ? null : MMUtils.fromInventory(upgrades);
        IInventory config = item.getConfigInventory(stack);
        cell.mConfig = config == null ? null : MMUtils.fromInventoryNoMerge(config);
        switch (item.getFuzzyMode(stack)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case IGNORE_ALL: {
                n = 0;
                break;
            }
            case PERCENT_25: {
                n = 1;
                break;
            }
            case PERCENT_50: {
                n = 2;
                break;
            }
            case PERCENT_75: {
                n = 3;
                break;
            }
            case PERCENT_99: {
                n = 4;
            }
        }
        cell.mFuzzyMode = (byte)n;
        IItemDefinition oredictCard = AEApi.instance().definitions().materials().cardOreFilter();
        boolean bl = hasOredictCard = upgrades == null ? false : MMUtils.streamInventory(upgrades).anyMatch(arg_0 -> ((IItemDefinition)oredictCard).isSameAs(arg_0));
        if (hasOredictCard) {
            cell.mOreDict = item.getOreFilter(stack);
        }
        return cell;
    }

    @Override
    public ItemStack getStack(IPseudoInventory inv, boolean consume) {
        FuzzyMode fuzzyMode;
        IInventory config;
        UpgradeInventory upgrades;
        ICellWorkbenchItem cellWorkbenchItem;
        ItemStack cell = this.mCell.toStack();
        Item item = cell.func_77973_b();
        if (!(item instanceof ICellWorkbenchItem) || !(cellWorkbenchItem = (ICellWorkbenchItem)item).isEditable(cell)) {
            return null;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(cell);
        items.addAll(MMUtils.mapToList(this.mUpgrades == null ? new PortableItemStack[]{} : this.mUpgrades, PortableItemStack::toStack));
        if (consume) {
            BooleanObjectImmutablePair<List<BigItemStack>> result = inv.tryConsumeItems(MMUtils.mapToList(items, BigItemStack::create), 2);
            if (!result.leftBoolean()) {
                return null;
            }
            for (BigItemStack extracted : (List)result.right()) {
                ItemStack extractedStack = extracted.getItemStack();
                if (!extractedStack.func_77969_a(cell)) continue;
                cell = extractedStack;
            }
        }
        if ((upgrades = (UpgradeInventory)cellWorkbenchItem.getUpgradesInventory(cell)) != null) {
            MMUtils.installUpgrades(inv, upgrades, this.mUpgrades, false, false);
            upgrades.func_70296_d();
        }
        if ((config = cellWorkbenchItem.getConfigInventory(cell)) != null) {
            MMUtils.clearInventory(config);
            for (int i = 0; i < this.mConfig.length; ++i) {
                if (this.mConfig[i] == null) continue;
                config.func_70299_a(i, this.mConfig[i].toStack());
            }
            config.func_70296_d();
        }
        switch (this.mFuzzyMode) {
            case 0: {
                fuzzyMode = FuzzyMode.IGNORE_ALL;
                break;
            }
            case 1: {
                fuzzyMode = FuzzyMode.PERCENT_25;
                break;
            }
            case 2: {
                fuzzyMode = FuzzyMode.PERCENT_50;
                break;
            }
            case 3: {
                fuzzyMode = FuzzyMode.PERCENT_75;
                break;
            }
            case 4: {
                fuzzyMode = FuzzyMode.PERCENT_99;
                break;
            }
            default: {
                fuzzyMode = FuzzyMode.IGNORE_ALL;
            }
        }
        cellWorkbenchItem.setFuzzyMode(cell, fuzzyMode);
        IItemDefinition oredictCard = AEApi.instance().definitions().materials().cardOreFilter();
        if (upgrades != null) {
            if (MMUtils.streamInventory((IInventory)upgrades).anyMatch(arg_0 -> ((IItemDefinition)oredictCard).isSameAs(arg_0))) {
                cellWorkbenchItem.setOreFilter(cell, this.mOreDict);
            }
        }
        return cell;
    }

    public String toString() {
        return this.mCell.toString();
    }

    @Override
    public AECellItemProvider clone() {
        AECellItemProvider dup = new AECellItemProvider();
        dup.mCell = this.mCell.clone();
        dup.mUpgrades = MMUtils.mapToArray(this.mUpgrades, PortableItemStack[]::new, x -> x == null ? null : x.clone());
        dup.mConfig = MMUtils.mapToArray(this.mConfig, PortableItemStack[]::new, x -> x == null ? null : x.clone());
        dup.mOreDict = this.mOreDict;
        dup.mFuzzyMode = this.mFuzzyMode;
        return dup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mCell == null ? 0 : this.mCell.hashCode());
        result = 31 * result + Arrays.hashCode(this.mUpgrades);
        result = 31 * result + Arrays.hashCode(this.mConfig);
        result = 31 * result + (this.mOreDict == null ? 0 : this.mOreDict.hashCode());
        result = 31 * result + this.mFuzzyMode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AECellItemProvider other = (AECellItemProvider)obj;
        if (this.mCell == null ? other.mCell != null : !this.mCell.equals(other.mCell)) {
            return false;
        }
        if (!Arrays.equals(this.mUpgrades, other.mUpgrades)) {
            return false;
        }
        if (!Arrays.equals(this.mConfig, other.mConfig)) {
            return false;
        }
        if (this.mOreDict == null ? other.mOreDict != null : !this.mOreDict.equals(other.mOreDict)) {
            return false;
        }
        return this.mFuzzyMode == other.mFuzzyMode;
    }
}

