/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockPropertyRegistry;
import com.recursive_pineapple.matter_manipulator.common.compat.IntrinsicProperty;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;

public class BlockStateCommand
extends CommandBase {
    public String func_71517_b() {
        return "state";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/state <get|set> [property name] [property value]";
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        String action = MMUtils.getIndexSafe(args, 0);
        String name = MMUtils.getIndexSafe(args, 1);
        String value = MMUtils.getIndexSafe(args, 2);
        if (action == null || "set".equals(action) && name != null && value == null) {
            MMUtils.sendErrorToPlayer(player, this.func_71518_a(sender));
            return;
        }
        MovingObjectPosition hit = MMUtils.getHitResult(player, true);
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.must_look_at_block"));
            return;
        }
        Object2ObjectOpenHashMap properties = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getProperties(player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, properties);
        Object2ObjectOpenHashMap intrinsicProps = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getIntrinsicProperties((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, (Map<String, IntrinsicProperty>)intrinsicProps);
        if ("get".equals(action)) {
            if (name != null) {
                BlockProperty prop = (BlockProperty)properties.get(name);
                if (prop != null) {
                    MMUtils.sendChatToPlayer(player, prop.getName() + ": " + prop.getValueAsString(player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d));
                    return;
                }
                IntrinsicProperty intrinsic = (IntrinsicProperty)intrinsicProps.get(name);
                if (intrinsic != null) {
                    MMUtils.sendChatToPlayer(player, intrinsic.getName() + ": " + intrinsic.getValue((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d));
                    return;
                }
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.property_not_found"));
            } else {
                if (properties.isEmpty() && intrinsicProps.isEmpty()) {
                    MMUtils.sendChatToPlayer(player, StatCollector.func_74838_a((String)"mm.info.properties"));
                    MMUtils.sendChatToPlayer(player, StatCollector.func_74838_a((String)"mm.info.none"));
                    return;
                }
                if (!properties.isEmpty()) {
                    MMUtils.sendChatToPlayer(player, StatCollector.func_74838_a((String)"mm.info.properties"));
                    for (Map.Entry e : properties.entrySet()) {
                        MMUtils.sendChatToPlayer(player, ((BlockProperty)e.getValue()).getName() + ": " + ((BlockProperty)e.getValue()).getValueAsString(player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d));
                    }
                }
                if (!intrinsicProps.isEmpty()) {
                    MMUtils.sendChatToPlayer(player, StatCollector.func_74838_a((String)"mm.info.intrinsic_properties"));
                    intrinsicProps.forEach((s, intrinsicProperty) -> MMUtils.sendChatToPlayer(player, intrinsicProperty.getName() + ": " + intrinsicProperty.getValue((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)));
                }
            }
        } else {
            BlockProperty prop = (BlockProperty)properties.get(name);
            if (prop != null) {
                try {
                    prop.setValueFromText(player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, value);
                }
                catch (Throwable t) {
                    MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.error_setting_property", (Object[])new Object[]{t.getMessage()}));
                }
                return;
            }
            IntrinsicProperty intrinsic = (IntrinsicProperty)intrinsicProps.get(name);
            if (intrinsic != null) {
                try {
                    intrinsic.setValue((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, (JsonElement)new Gson().fromJson(value, JsonElement.class));
                }
                catch (Throwable t) {
                    MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.error_setting_property", (Object[])new Object[]{t.getMessage()}));
                }
                return;
            }
            MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.property_not_found"));
        }
    }
}

