/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.AbstractBuildable;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMConfig;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.networking.SoundResource;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import com.recursive_pineapple.matter_manipulator.mixin.BlockCaptureDrops;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IIC2Enet;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;

public class PendingMove
extends AbstractBuildable {
    private List<Pair<Location, Location>> moves = null;

    public PendingMove(EntityPlayer player, MMState state, ItemMatterManipulator.ManipulatorTier tier) {
        super(player, state, tier);
    }

    @Override
    public void tryPlaceBlocks(ItemStack stack, EntityPlayer player) {
        this.resetWarnings();
        this.refillPower(stack);
        if (this.moves == null) {
            this.initMoves();
        }
        World world = player.field_70170_p;
        BlockSpec source = new BlockSpec();
        BlockSpec target = new BlockSpec();
        int ops = 0;
        ListIterator<Pair<Location, Location>> iter = this.moves.listIterator(this.moves.size());
        ArrayList<Pair<Location, Location>> shuffled = new ArrayList<Pair<Location, Location>>();
        while (ops < this.tier.placeSpeed && iter.hasPrevious()) {
            Pair<Location, Location> move = iter.previous();
            Location s = (Location)move.left();
            Location d = (Location)move.right();
            if (!this.isEditable(world, s.x, s.y, s.z) || !this.isEditable(world, d.x, d.y, d.z)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_protected_block", (Object[])new Object[]{s.x, s.y, s.z, source.getDisplayName()}));
                iter.remove();
                continue;
            }
            BlockSpec.fromBlock(source, world, s.x, s.y, s.z);
            if (source.isAir()) {
                iter.remove();
                continue;
            }
            if (source.getBlock().func_149712_f(world, s.x, s.y, s.z) < 0.0f) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_invulnerable_block", (Object[])new Object[]{s.x, s.y, s.z, source.getDisplayName()}));
                iter.remove();
                continue;
            }
            BlockSpec.fromBlock(target, world, d.x, d.y, d.z);
            switch (this.state.config.removeMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    boolean bl = target.getBlock().isAir((IBlockAccess)world, d.x, d.y, d.z);
                    break;
                }
                case REPLACEABLE: {
                    boolean bl = target.getBlock().isReplaceable((IBlockAccess)world, d.x, d.y, d.z);
                    break;
                }
                case ALL: {
                    boolean canPlace;
                    boolean bl = canPlace = true;
                }
            }
            if (!(canPlace &= target.getBlock().func_149712_f(world, d.x, d.y, d.z) >= 0.0f)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_blocked_block", (Object[])new Object[]{d.x, d.y, d.z, source.getDisplayName()}));
                iter.remove();
                continue;
            }
            if (!target.getBlock().isAir((IBlockAccess)world, d.x, d.y, d.z)) {
                if (!this.tryConsumePower(stack, world, d.x, d.y, d.z, target)) {
                    MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.out_of_eu"));
                    break;
                }
                this.removeBlock(world, d.x, d.y, d.z, target);
            }
            if (!source.getBlock().func_149742_c(world, d.x, d.y, d.z)) {
                shuffled.add(move);
                iter.remove();
                continue;
            }
            if (!this.tryConsumePower(stack, world, s.x, s.y, s.z, source)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.out_of_eu"));
                break;
            }
            if (!PendingMove.swapBlocks(world, s, source, d, target)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_block", (Object[])new Object[]{s.x, s.y, s.z, source.getDisplayName()}));
            }
            this.playSound(world, s.x, s.y, s.z, SoundResource.MOB_ENDERMEN_PORTAL);
            this.playSound(world, d.x, d.y, d.z, SoundResource.MOB_ENDERMEN_PORTAL);
            iter.remove();
            ++ops;
        }
        this.moves.addAll(shuffled);
        this.playSounds();
        this.actuallyGivePlayerStuff();
        if (ops > 0) {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.process_move", (Object[])new Object[]{ops, this.moves.size()}));
        } else {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.finished_move"));
        }
    }

    @Override
    public void onStopped() {
    }

    private void initMoves() {
        this.moves = new ArrayList<Pair<Location, Location>>();
        Location startA = this.state.config.coordA;
        Location startB = this.state.config.coordB;
        Location dest = this.state.config.coordC;
        MMConfig.VoxelAABB cut = new MMConfig.VoxelAABB(startA.toVec(), startB.toVec());
        MMConfig.VoxelAABB paste = cut.clone().moveOrigin(dest.toVec());
        if (cut.toBoundingBox().func_72326_a(paste.toBoundingBox())) {
            MMUtils.sendErrorToPlayer(this.player, StatCollector.func_74838_a((String)"mm.info.error.move_overlapping"));
            return;
        }
        int x1 = startA.x;
        int y1 = startA.y;
        int z1 = startA.z;
        int x2 = startB.x;
        int y2 = startB.y;
        int z2 = startB.z;
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        int worldId = startA.worldId;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int dX = x - x1;
                    int dY = y - y1;
                    int dZ = z - z1;
                    this.moves.add((Pair<Location, Location>)Pair.of((Object)new Location(worldId, x, y, z), (Object)new Location(worldId, dest.x + dX, dest.y + dY, dest.z + dZ)));
                }
            }
        }
    }

    public static boolean swapBlocks(World world, Location s, BlockSpec spec1, Location d, BlockSpec spec2) {
        World worldS = world.field_73011_w.field_76574_g == s.worldId ? world : s.getWorld();
        int sx = s.x;
        int sy = s.y;
        int sz = s.z;
        World worldD = world.field_73011_w.field_76574_g == d.worldId ? world : d.getWorld();
        int dx = d.x;
        int dy = d.y;
        int dz = d.z;
        TileEntity tileEntityS = worldS.func_147438_o(sx, sy, sz);
        TileEntity tileEntityD = worldD.func_147438_o(dx, dy, dz);
        NBTTagCompound tagS = new NBTTagCompound();
        NBTTagCompound tagD = new NBTTagCompound();
        if (tileEntityS != null) {
            tileEntityS.func_145841_b(tagS);
        }
        if (tileEntityD != null) {
            tileEntityD.func_145841_b(tagD);
        }
        Block blockS = worldS.func_147439_a(sx, sy, sz);
        Block blockD = worldD.func_147439_a(dx, dy, dz);
        if (blockS.equals(Blocks.field_150350_a) && blockD.equals(Blocks.field_150350_a)) {
            return false;
        }
        int metaS = worldS.func_72805_g(sx, sy, sz);
        int metaD = worldD.func_72805_g(dx, dy, dz);
        if (Mods.BloodMagic.isModLoaded() && !PendingMove.allowTelepose(worldS, worldD, s, spec1, d, spec2)) {
            return false;
        }
        blockS.getDrops(world, sx, sy, sz, metaS, 0);
        blockD.getDrops(world, dx, dy, dz, metaD, 0);
        worldD.func_147455_a(dx, dy, dz, blockD.createTileEntity(worldD, metaD));
        worldS.func_147455_a(sx, sy, sz, blockS.createTileEntity(worldS, metaS));
        BlockCaptureDrops.captureDrops(blockS);
        BlockCaptureDrops.captureDrops(blockD);
        BlockCaptureDrops.captureDrops(world);
        worldD.func_147465_d(dx, dy, dz, blockS, metaS, 3);
        if (tileEntityS != null) {
            TileEntity newTileEntityI = TileEntity.func_145827_c((NBTTagCompound)tagS);
            worldD.func_147455_a(dx, dy, dz, newTileEntityI);
            newTileEntityI.field_145851_c = dx;
            newTileEntityI.field_145848_d = dy;
            newTileEntityI.field_145849_e = dz;
        }
        worldS.func_147465_d(sx, sy, sz, blockD, metaD, 3);
        BlockCaptureDrops.stopCapturingDrops(blockS);
        BlockCaptureDrops.stopCapturingDrops(blockD);
        BlockCaptureDrops.stopCapturingDrops(world);
        if (tileEntityD != null) {
            TileEntity newTileEntityF = TileEntity.func_145827_c((NBTTagCompound)tagD);
            worldS.func_147455_a(sx, sy, sz, newTileEntityF);
            newTileEntityF.field_145851_c = sx;
            newTileEntityF.field_145848_d = sy;
            newTileEntityF.field_145849_e = sz;
            if (Mods.GregTech.isModLoaded()) {
                PendingMove.updateGTIfNeeded(newTileEntityF);
            }
        }
        return true;
    }

    @Optional(value={"gregtech_nh"})
    private static void updateGTIfNeeded(TileEntity te) {
        if (te instanceof IGregTechTileEntity) {
            IMetaTileEntity imte;
            IGregTechTileEntity igte = (IGregTechTileEntity)te;
            if (igte instanceof BaseMetaTileEntity) {
                BaseMetaTileEntity bmte = (BaseMetaTileEntity)igte;
                bmte.setCableUpdateDelay(100);
            }
            if ((imte = igte.getMetaTileEntity()) instanceof MTEPipeLaser) {
                MTEPipeLaser laserPipe = (MTEPipeLaser)imte;
                laserPipe.updateNeighboringNetworks();
            }
            if (imte instanceof MTEPipeData) {
                MTEPipeData dataPipe = (MTEPipeData)imte;
                dataPipe.updateNeighboringNetworks();
            }
        }
        if (te instanceof IIC2Enet) {
            IIC2Enet enet = (IIC2Enet)te;
            enet.doEnetUpdate();
        }
    }

    @Optional(value={"AWWayofTime"})
    private static boolean allowTelepose(World worldI, World worldF, Location s, BlockSpec spec1, Location d, BlockSpec spec2) {
        TeleposeEvent evt = new TeleposeEvent(worldI, s.x, s.y, s.z, spec1.getBlock(), spec2.getBlockMeta(), worldF, d.x, d.y, d.z, spec2.getBlock(), spec2.getBlockMeta());
        return !MinecraftForge.EVENT_BUS.post((Event)evt);
    }
}

