/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.recursive_pineapple.matter_manipulator.common.building.CopyableProperty;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.utils.ImmutableItemMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public interface ImmutableBlockSpec
extends ImmutableItemMeta {
    public GameRegistry.UniqueIdentifier getObjectId();

    @Override
    public Block getBlock();

    @Override
    public Item getItem();

    public ItemId getItemId();

    @Override
    public int getMeta();

    public int getBlockMeta();

    public ItemStack getStack();

    public PendingBlock instantiate(int var1, int var2, int var3, int var4);

    default public PendingBlock instantiate(World world, int x, int y, int z) {
        return this.instantiate(world.field_73011_w.field_76574_g, x, y, z);
    }

    public String getProperty(CopyableProperty var1);

    public ImmutableBlockSpec withProperties(Map<CopyableProperty, String> var1);

    default public boolean isEquivalent(ImmutableBlockSpec other) {
        return ItemStack.func_77989_b((ItemStack)this.getStack(), (ItemStack)other.getStack());
    }

    default public boolean isAir() {
        return this.getObjectId() == null || this.getBlock() == null || InteropConstants.isAir(this.getBlock(), this.getBlockMeta());
    }

    default public boolean skipWhenCopying() {
        return InteropConstants.skipWhenCopying(this.getBlock(), this.getBlockMeta());
    }

    default public boolean shouldDropItem() {
        return InteropConstants.shouldDropItem(this.getBlock(), this.getBlockMeta());
    }

    default public boolean isFree() {
        return InteropConstants.isFree(this.getBlock(), this.getBlockMeta());
    }

    public void getItemDetails(List<String> var1);

    public static Comparator<ImmutableBlockSpec> getComparator() {
        return Comparator.comparing(ImmutableBlockSpec::getStack, (a, b) -> {
            if (a == null && b != null) {
                return -1;
            }
            if (a != null && b == null) {
                return 1;
            }
            if (a == null && b == null) {
                return 0;
            }
            if (!1.$assertionsDisabled && a.func_77973_b() == null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && b.func_77973_b() == null) {
                throw new AssertionError();
            }
            int result = String.CASE_INSENSITIVE_ORDER.compare(a.func_77973_b().delegate.name(), b.func_77973_b().delegate.name());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(a.field_77991_e, b.field_77991_e);
            if (result != 0) {
                return result;
            }
            NBTTagCompound ta = a.func_77978_p();
            NBTTagCompound tb = b.func_77978_p();
            if (ta == null && tb != null) {
                return -1;
            }
            if (ta != null && tb == null) {
                return 1;
            }
            if (ta == null && tb == null) {
                return 0;
            }
            return Integer.compare(ta.hashCode(), tb.hashCode());
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

