/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.Cover;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class CoverData {
    public PortableItemStack cover;
    public int coverID;
    public NBTTagCompound coverData;

    public CoverData() {
    }

    public CoverData(PortableItemStack cover, int coverID, NBTTagCompound coverData) {
        this.cover = cover;
        this.coverID = coverID;
        this.coverData = coverData;
    }

    public ItemStack getCoverStack() {
        return this.cover.toStack();
    }

    public CoverData clone() {
        CoverData dup = new CoverData();
        dup.cover = this.cover.clone();
        dup.coverID = this.coverID;
        dup.coverData = (NBTTagCompound)this.coverData.func_74737_b();
        return dup;
    }

    public static CoverData fromMachine(ICoverable coverable, ForgeDirection dir) {
        if (!coverable.hasCoverAtSide(dir)) {
            return null;
        }
        Cover cover = coverable.getCoverAtSide(dir);
        return new CoverData(PortableItemStack.withNBT(coverable.getCoverItemAtSide(dir)), cover.getCoverID(), cover.writeToNBT(new NBTTagCompound()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cover == null ? 0 : this.cover.hashCode());
        result = 31 * result + this.coverID;
        result = 31 * result + (this.coverData == null ? 0 : this.coverData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoverData other = (CoverData)obj;
        if (this.cover == null ? other.cover != null : !this.cover.equals(other.cover)) {
            return false;
        }
        if (other.coverID != this.coverID) {
            return false;
        }
        return !(this.coverData == null ? other.coverData != null : !this.coverData.equals((Object)other.coverData));
    }
}

