/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import net.malisis.core.util.parser.Parser;
import net.malisis.core.util.parser.token.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class HTMLParser
extends Parser<HTMLNode> {
    private HTMLNode currentNode;
    private HTMLNode rootNode;
    private LinkedList<HTMLNode> openTags = new LinkedList();

    public HTMLParser(String text) {
        super(text);
        this.withTokens(Token.Inferior, Token.Superior, Token.Div, Token.Identifier, Token.Equal, Token.StringToken);
        this.ignoreTokens(Token.Space);
    }

    @Override
    public Token readToken() {
        Token t;
        while ((t = super.readToken()) == Token.Space) {
        }
        return t;
    }

    @Override
    public HTMLNode parse() {
        this.currentNode = this.rootNode = new HTMLNode("document", null);
        String content = null;
        MutableObject identifier = new MutableObject();
        while (!this.isEnd()) {
            if (this.match(Token.Inferior)) {
                if (this.match(Token.Div)) {
                    this.readToken();
                    this.closeTag();
                } else if (this.match(Token.Identifier, (Mutable)identifier)) {
                    this.openTag((String)identifier.getValue());
                    while (this.match(Token.Identifier, (Mutable)identifier)) {
                        String attr = (String)identifier.getValue();
                        if (!this.match(Token.Equal)) {
                            this.addAttribute((String)identifier.getValue());
                            continue;
                        }
                        if (!this.match(Token.StringToken, (Mutable)identifier)) continue;
                        this.addAttribute(attr, (String)identifier.getValue());
                    }
                    if (this.match(Token.Div)) {
                        this.closeTag();
                    }
                }
                if (!this.match(Token.Superior)) {
                    this.error(Token.Superior);
                }
            }
            if (StringUtils.isEmpty((CharSequence)(content = this.readUntil(Token.Inferior)))) continue;
            this.addContent(content);
        }
        return this.rootNode;
    }

    public void openTag(String tag) {
        if (this.currentNode == null) {
            return;
        }
        HTMLNode node = new HTMLNode(tag);
        this.currentNode.AddNode(node);
        this.openTags.add(this.currentNode);
        this.currentNode = node;
    }

    public void addAttribute(String attr) {
        this.addAttribute(attr, null);
    }

    public void addAttribute(String attr, String attr_val) {
        if (this.currentNode != null) {
            this.currentNode.AddAttribute(attr, attr_val);
        }
    }

    public void addContent(String str) {
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.AddText(str);
    }

    public void closeTag() {
        if (this.openTags.size() == 0) {
            return;
        }
        this.currentNode = this.openTags.removeLast();
    }

    public HTMLNode getRootNode() {
        return this.rootNode;
    }

    public static class HTMLNode {
        public String name = null;
        public int level = 0;
        public HTMLNode parent = null;
        public Multimap<String, String> attributes = ArrayListMultimap.create();
        public LinkedList<HTMLNode> nodes = new LinkedList();
        public String text = null;

        public HTMLNode(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public HTMLNode(String name) {
            this(name, null);
        }

        public void AddAttribute(String attr, String val) {
            this.attributes.put((Object)attr, (Object)val);
        }

        public void AddNode(HTMLNode node) {
            if (!StringUtils.isEmpty((CharSequence)this.text)) {
                throw new IllegalArgumentException("Text already defined for node.");
            }
            node.level = this.level + 1;
            node.parent = this;
            this.nodes.add(node);
        }

        public void AddText(String text) {
            this.AddNode(new HTMLNode(null, text));
        }

        public String prettyPrint() {
            int n = 4;
            if (this.text != null) {
                return StringUtils.repeat((char)' ', (int)(this.level * n)) + this.text + "\n";
            }
            String s = StringUtils.repeat((char)' ', (int)(this.level * n)) + "<" + this.name + (this.attributes.size() != 0 ? " " + this.attributes.toString() : "") + ">\n";
            for (HTMLNode node : this.nodes) {
                s = s + node.prettyPrint();
            }
            if (this.nodes.size() != 0) {
                s = s + StringUtils.repeat((char)' ', (int)(this.level * n)) + "</" + this.name + ">\n";
            }
            return s;
        }

        public String toString() {
            return this.prettyPrint();
        }
    }
}

