/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import com.google.common.base.Objects;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.MultiBlock;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.BigDoor;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.movement.CarriageDoorMovement;
import net.malisis.doors.door.sound.CarriageDoorSound;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BigDoorTileEntity
extends DoorTileEntity {
    private boolean delete = false;
    private boolean processed = true;
    private ForgeDirection direction = ForgeDirection.NORTH;
    private BlockState frameState;

    public BigDoorTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(CarriageDoorMovement.class));
        descriptor.setSound(DoorRegistry.getSound(CarriageDoorSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(20);
        this.setDescriptor(descriptor);
        this.frameState = new BlockState(Blocks.field_150371_ca);
    }

    public BlockState getFrameState() {
        return this.frameState;
    }

    public void setFrameState(BlockState state) {
        if (state != null) {
            this.frameState = state;
        }
    }

    @Override
    public boolean isTopBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    @Override
    public void setDoorState(DoorState newState) {
        boolean moving = this.moving;
        BlockState state = null;
        if (this.func_145831_w() != null) {
            state = new BlockState(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        super.setDoorState(newState);
    }

    @Override
    public void func_145845_h() {
        if (!this.processed && this.func_145831_w() != null) {
            if (this.delete) {
                MalisisCore.log.info("Deleting " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                MalisisCore.log.info("Adding to chunk : " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e);
                this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, Door.dirToInt(this.direction), 2);
                this.processed = true;
            }
            return;
        }
        super.func_145845_h();
    }

    public ItemStack getDroppedItemStack() {
        ItemStack itemStack = new ItemStack(this.func_145838_q());
        NBTTagCompound nbt = new NBTTagCompound();
        BlockState.toNBT(nbt, this.frameState);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("multiBlock")) {
            MultiBlock mb = new MultiBlock(tag);
            this.delete = !mb.isOrigin(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.direction = mb.getDirection();
            this.processed = false;
        }
        this.frameState = (BlockState)Objects.firstNonNull((Object)BlockState.fromNBT(tag), (Object)new BlockState(Blocks.field_150371_ca));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        BlockState.toNBT(nbt, this.frameState);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return ((BigDoor)this.func_145838_q()).getBoundingBox((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, BoundingBoxType.RENDER)[0].func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }
}

