/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Scale;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SpinningDoorMovement
implements IDoorMovement {
    private Rotation rotBot = new Rotation(0.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotTop = new Rotation(0.0f).aroundAxis(0.0f, 0.0f, 1.0f).offset(0.0f, 1.0f, 0.0f);
    private Scale scaleBot = new Scale(0.0f, 0.0f, 0.0f);
    private Scale scaleTop = new Scale(0.0f, 0.0f, 0.0f).offset(0.0f, 1.0f, 0.0f);

    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (tileEntity.isOpened() && type != BoundingBoxType.RAYTRACE) {
            return null;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                aabb.field_72337_e += 1.0;
            } else {
                aabb.field_72338_b -= 1.0;
            }
        }
        return aabb;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        float angle = tileEntity.isReversed() ? -720.0f : 720.0f;
        boolean closed = tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED;
        int ot = tileEntity.getDescriptor().getOpeningTime();
        this.rotBot.from(angle);
        this.rotBot.reversed(closed);
        this.rotBot.forTicks(ot);
        this.rotTop.from(angle);
        this.rotTop.reversed(closed);
        this.rotTop.forTicks(ot);
        this.scaleBot.reversed(closed);
        this.scaleBot.forTicks(ot);
        this.scaleTop.reversed(closed);
        this.scaleTop.forTicks(ot);
        ParallelTransformation bot = new ParallelTransformation(new Transformation[]{this.rotBot, this.scaleBot});
        ParallelTransformation top = new ParallelTransformation(new Transformation[]{this.rotTop, this.scaleTop});
        return new Animation[]{new Animation((ITransformable)model.getShape("bottom"), (Transformation)bot), new Animation((ITransformable)model.getShape("top"), (Transformation)top)};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

