/*
 * Decompiled with CFR 0.152.
 */
package magicbees.world.feature;

import java.util.Random;
import magicbees.main.utils.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class FeatureOreVein {
    public static final FeatureOreVein redstoneGen = new FeatureOreVein(Blocks.field_150450_ax, Blocks.field_150348_b);
    public static final FeatureOreVein netherQuartzGen = new FeatureOreVein(Blocks.field_150449_bY, Blocks.field_150424_aL);
    public static final FeatureOreVein glowstoneGen = new FeatureOreVein(Blocks.field_150426_aN, Blocks.field_150348_b);
    public static final FeatureOreVein endStoneGen = new FeatureOreVein(Blocks.field_150377_bs, Blocks.field_150348_b);
    private final Block veinBlock;
    private final int veinBlockMeta;
    private final Block replacesBlock;

    public FeatureOreVein(Block block, Block replacesBlock) {
        this(block, 0, replacesBlock);
    }

    public FeatureOreVein(Block block, int meta, Block replacesBlock) {
        this.veinBlock = block;
        this.veinBlockMeta = meta;
        this.replacesBlock = replacesBlock;
    }

    public void generateVein(World world, Random random, int startX, int startY, int startZ, int maxSpawnCount) {
        int currentX = startX;
        int currentY = startY;
        int currentZ = startZ;
        int spawnAttempts = 0;
        int spawnCount = 0;
        while (spawnCount < maxSpawnCount && spawnAttempts < maxSpawnCount * 2) {
            ++spawnAttempts;
            if (!world.func_147437_c(currentX, currentY, currentZ) && BlockUtil.canBlockReplaceAt(world, currentX, currentY, currentZ, this.replacesBlock)) {
                world.func_147465_d(currentX, currentY, currentZ, this.veinBlock, this.veinBlockMeta, 2);
                ++spawnCount;
            }
            switch (random.nextInt(6)) {
                case 0: {
                    ++currentY;
                    break;
                }
                case 1: {
                    --currentY;
                    break;
                }
                case 2: {
                    ++currentZ;
                    break;
                }
                case 3: {
                    --currentZ;
                    break;
                }
                case 4: {
                    ++currentX;
                    break;
                }
                case 5: {
                    --currentX;
                }
            }
        }
    }
}

