/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import magicbees.bees.BeeManager;
import magicbees.tileentity.TileEntityEffectJar;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class EffectJarHousing
implements IBeeHousing {
    private static final IErrorLogic errorLogic = new JarErrorLogic();
    private static final Iterable<IBeeListener> beeListeners = ImmutableSet.of((Object)new DefaultBeeListener());
    private static final Iterable<IBeeModifier> beeModifiers = ImmutableSet.of((Object)new JarHousingModifier());
    private final IBeekeepingLogic beekeepingLogic;
    private final TileEntityEffectJar jarEntity;
    private final BiomeGenBase biome;
    private final IBeeHousingInventory inventory;

    public EffectJarHousing(TileEntityEffectJar entity) {
        this.jarEntity = entity;
        this.biome = entity.func_145831_w().func_72807_a(entity.field_145851_c, entity.field_145849_e);
        this.inventory = new JarBeeHousingInventory(entity);
        this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic((IBeeHousing)this);
    }

    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.jarEntity.field_145851_c, this.jarEntity.field_145848_d, this.jarEntity.field_145849_e);
    }

    public BiomeGenBase getBiome() {
        return this.biome;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome((BiomeGenBase)this.biome, (int)this.jarEntity.field_145851_c, (int)this.jarEntity.field_145848_d, (int)this.jarEntity.field_145849_e);
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.biome.field_76751_G);
    }

    public int getBlockLightValue() {
        return this.jarEntity.func_145831_w().func_72957_l(this.jarEntity.field_145851_c, this.jarEntity.field_145848_d + 1, this.jarEntity.field_145849_e);
    }

    public boolean canBlockSeeTheSky() {
        return this.jarEntity.func_145831_w().func_72937_j(this.jarEntity.field_145851_c, this.jarEntity.field_145848_d + 1, this.jarEntity.field_145849_e);
    }

    public World getWorld() {
        return this.jarEntity.func_145831_w();
    }

    public GameProfile getOwner() {
        return this.jarEntity.getOwner();
    }

    public Vec3 getBeeFXCoordinates() {
        return Vec3.func_72443_a((double)((float)this.jarEntity.field_145851_c + 0.5f), (double)((float)this.jarEntity.field_145848_d + 0.5f), (double)((float)this.jarEntity.field_145849_e + 0.5f));
    }

    public IErrorLogic getErrorLogic() {
        return errorLogic;
    }

    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    public Iterable<IBeeModifier> getBeeModifiers() {
        return beeModifiers;
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return beeListeners;
    }

    private static class JarHousingModifier
    implements IBeeModifier {
        private JarHousingModifier() {
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 0.9f;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public boolean isSealed() {
            return true;
        }

        public boolean isSelfLighted() {
            return true;
        }

        public boolean isSunlightSimulated() {
            return true;
        }

        public boolean isHellish() {
            return false;
        }
    }

    private static class JarErrorLogic
    implements IErrorLogic {
        private JarErrorLogic() {
        }

        public boolean setCondition(boolean condition, IErrorState errorState) {
            return condition;
        }

        public boolean contains(IErrorState state) {
            return false;
        }

        public boolean hasErrors() {
            return false;
        }

        public void clearErrors() {
        }

        public void writeData(DataOutputStream data) throws IOException {
        }

        public void readData(DataInputStream data) throws IOException {
        }

        public ImmutableSet<IErrorState> getErrorStates() {
            return ImmutableSet.of();
        }
    }

    private static class JarBeeHousingInventory
    implements IBeeHousingInventory {
        private final TileEntityEffectJar jarEntity;

        public JarBeeHousingInventory(TileEntityEffectJar jarEntity) {
            this.jarEntity = jarEntity;
        }

        public ItemStack getQueen() {
            return this.jarEntity.func_70301_a(1);
        }

        public ItemStack getDrone() {
            return null;
        }

        public void setQueen(ItemStack itemStack) {
            this.jarEntity.func_70299_a(1, itemStack);
        }

        public void setDrone(ItemStack itemstack) {
        }

        public boolean addProduct(ItemStack product, boolean all) {
            return false;
        }
    }
}

