/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.net;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import magicbees.main.utils.ChunkCoords;
import magicbees.main.utils.LogHelper;
import magicbees.main.utils.net.EventCoords;
import magicbees.main.utils.net.NetworkEventHandler;
import magicbees.tileentity.AuraCharges;
import magicbees.tileentity.ITileEntityAuraCharged;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class EventAuraChargeUpdate
extends EventCoords {
    private int flags;

    public EventAuraChargeUpdate(ChunkCoords position, AuraCharges auraCharges) {
        super(NetworkEventHandler.EventType.AURA_CHARGE_UPDATE, position);
        this.flags = auraCharges.writeToFlags();
    }

    public EventAuraChargeUpdate(DataInputStream byteStream) {
        super(NetworkEventHandler.EventType.FLAGS_UPDATE, byteStream);
        this.readDataFromInputStream(byteStream);
    }

    @Override
    protected void writeDataToOutputStream(DataOutputStream byteStream) {
        super.writeDataToOutputStream(byteStream);
        try {
            byteStream.writeInt(this.flags);
        }
        catch (IOException e) {
            LogHelper.error("Could not write EventAuraChargeUpdate data to stream.");
            e.printStackTrace();
        }
    }

    @Override
    protected void readDataFromInputStream(DataInputStream byteStream) {
        super.readDataFromInputStream(byteStream);
        try {
            this.flags = byteStream.readInt();
        }
        catch (IOException e) {
            LogHelper.error("Could not read EventAuraChargeUpdate data from stream.");
            e.printStackTrace();
        }
    }

    @Override
    public void process(EntityPlayerMP player) {
        TileEntity tile = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(this.getCoords().x, this.getCoords().y, this.getCoords().z);
        if (tile != null && tile instanceof ITileEntityAuraCharged) {
            AuraCharges auraCharges = ((ITileEntityAuraCharged)tile).getAuraCharges();
            auraCharges.readFromFlags(this.flags);
        }
    }
}

