/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IAlleleBeeAcceleratableEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import magicbees.bees.AlleleEffect;
import magicbees.bees.BeeManager;
import magicbees.bees.allele.effect.EffectData;
import magicbees.main.Config;
import magicbees.main.utils.BlockUtil;
import magicbees.main.utils.compat.thaumcraft.NodeHelper;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;

public class AlleleEffectEmpowering
extends AlleleEffect
implements IAlleleBeeAcceleratableEffect {
    public AlleleEffectEmpowering(String id, boolean isDominant) {
        super(id, isDominant, 200);
        this.combinable = true;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (!(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int range = Math.max((int)Math.ceil((float)genome.getTerritory()[0] * beeModifier.getTerritoryModifier(genome, 1.0f)), 1);
        List<Chunk> chunks = BlockUtil.getChunksInSearchRange(world, coords.field_71574_a, coords.field_71573_c, range);
        if (NodeHelper.growNodeInRange(chunks, world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, range)) {
            storedData.setInteger(0, storedData.getInteger(0) - this.throttle);
        }
        return storedData;
    }

    public IEffectData doEffectAccelerated(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, float did) {
        storedData.setInteger(0, 0);
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int range = Math.max((int)Math.ceil((float)genome.getTerritory()[0] * beeModifier.getTerritoryModifier(genome, 1.0f)), 1);
        List<Chunk> chunks = BlockUtil.getChunksInSearchRange(world, coords.field_71574_a, coords.field_71573_c, range);
        int idid = (int)did;
        ArrayList<INode> nodes = new ArrayList<INode>(idid);
        Collections.shuffle(chunks);
        for (Chunk chunk : chunks) {
            List<INode> l = NodeHelper.findNodesInChunkWithinRange(chunk, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, range);
            nodes.addAll(l);
            if ((idid -= l.size()) > 0) continue;
            while (idid < 0) {
                nodes.remove(0);
                ++idid;
            }
            break block0;
        }
        if (nodes.isEmpty()) {
            return storedData;
        }
        if ((did /= (float)nodes.size()) < 1.0f) {
            did = 1.0f;
        }
        for (INode node : nodes) {
            Aspect aspectToAdd;
            AspectList aspectsBase = node.getAspectsBase();
            int randBase = Math.max(aspectsBase.visSize(), 1);
            if (world.field_73012_v.nextInt(randBase) >= 120) continue;
            int rollAttempts = 0;
            while (aspectsBase.getAmount(aspectToAdd = NodeHelper.getWeightedRandomAspect(world.field_73012_v)) > Config.thaumcraftNodeMaxSize - 1 && ++rollAttempts < 20) {
            }
            if (20 <= rollAttempts) continue;
            short amount = (short)((int)did + world.field_73012_v.nextInt((int)(2.0f * did)));
            aspectsBase.add(aspectToAdd, (int)amount);
            node.getAspects().add(aspectToAdd, (int)amount);
            NodeHelper.updateNode(node, world);
        }
        return storedData;
    }
}

