/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.api;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ConfigUtils {
    private Class<?> configClass;
    private String modVersion;
    private MethodHandle getExtensibleEnumsHandle;
    private MethodHandle addExtensibleEnumHandle;
    private MethodHandle isConfigLoadedHandle;

    public ConfigUtils(Logger logger) {
        block2: {
            this.modVersion = "";
            try {
                this.configClass = Class.forName("me.eigenraven.lwjgl3ify.core.Config");
                this.modVersion = (String)this.configClass.getField("LWJGL3IFY_VERSION").get(null);
                MethodHandles.Lookup lookup = MethodHandles.publicLookup().in(this.configClass);
                this.getExtensibleEnumsHandle = lookup.findStatic(this.configClass, "getExtensibleEnums", MethodType.methodType(Set.class));
                this.addExtensibleEnumHandle = lookup.findStatic(this.configClass, "addExtensibleEnum", MethodType.methodType(Void.TYPE, String.class));
                this.isConfigLoadedHandle = lookup.findStatic(this.configClass, "isConfigLoaded", MethodType.methodType(Boolean.TYPE));
            }
            catch (ReflectiveOperationException e) {
                this.configClass = null;
                if (logger == null) break block2;
                logger.warn("Could not find lwjgl3ify in the classpath", (Throwable)e);
            }
        }
    }

    public boolean isLwjgl3ifyLoaded() {
        return this.configClass != null;
    }

    public Set<String> getExtensibleEnums() {
        try {
            if (this.configClass != null) {
                return this.getExtensibleEnumsHandle.invokeExact();
            }
            return Collections.emptySet();
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    public void addExtensibleEnum(String className) {
        try {
            if (this.configClass != null) {
                this.addExtensibleEnumHandle.invokeExact(className);
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    public boolean isConfigLoaded() {
        try {
            if (this.configClass != null) {
                return this.isConfigLoadedHandle.invokeExact();
            }
            return false;
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }
}

