/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.ui.tooltip.AlignableTooltipBorder;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.ui.util.WindowUtil;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public final class ToolTipUtil {
    public static void applyContext(JToolTip toolTip) {
        JComponent target = toolTip.getComponent();
        if (target == null) {
            return;
        }
        ToolTipContext context = ToolTipUtil.getToolTipContext(toolTip);
        if (context == null) {
            return;
        }
        context.setTarget(target);
        context.setToolTip(toolTip);
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, target);
        LocationResult pos = ToolTipUtil.getBestPositionMatch(context, p);
        if (pos.point != null) {
            ToolTipUtil.moveToolTip(toolTip, pos, target);
        }
    }

    private static LocationResult getBestPositionMatch(ToolTipContext context, Point p) {
        LocationResult result;
        BiConsumer<ToolTipContext, Alignment> setter;
        Alignment targetAlignment;
        if (!context.isBestFit()) {
            return new LocationResult(context.getToolTipLocation(p, null), true);
        }
        Alignment original = context.getAlignment();
        Alignment originalCenter = context.getCenterAlignment();
        LayoutConstraints layoutConstraints = ToolTipUtil.calculateLayoutConstraints(context, p);
        boolean isCenter = original == Alignment.CENTER;
        Alignment alignment = targetAlignment = isCenter ? originalCenter : original;
        if (context.isChooseBestInitialAlignment()) {
            targetAlignment = ToolTipUtil.probeAlignment(context, layoutConstraints);
        }
        boolean centerVertically = targetAlignment.isHorizontal();
        boolean centerHorizontally = targetAlignment.isVertical();
        Alignment[] alignments = ToolTipUtil.getAlignments(targetAlignment);
        Point pos = ToolTipUtil.tryAlignments(alignments, context, p, layoutConstraints, setter = isCenter ? ToolTipContext::setCenterAlignment : ToolTipContext::setAlignment, centerHorizontally, centerVertically);
        if (pos == null) {
            layoutConstraints.windowBounds.setBounds(layoutConstraints.screenBoundary);
            pos = ToolTipUtil.tryAlignments(alignments, context, p, layoutConstraints, setter, centerHorizontally, centerVertically);
        }
        if (pos == null) {
            context.setAlignment(Alignment.CENTER);
            context.setCenterAlignment(Alignment.CENTER);
            result = new LocationResult(context.getFallBackPositionProvider().calculateFallbackPosition(context), !context.getFallBackPositionProvider().providesAbsolutePosition());
        } else {
            result = new LocationResult(pos, true);
        }
        context.updateToolTip();
        context.setAlignment(original);
        context.setCenterAlignment(originalCenter);
        return result;
    }

    private static Alignment probeAlignment(ToolTipContext context, LayoutConstraints layoutConstraints) {
        JComponent target = context.getTarget();
        if (target == null) {
            return Alignment.SOUTH;
        }
        Rectangle targetBounds = target.getBounds();
        Point center = new Point(targetBounds.width / 2, targetBounds.height / 2);
        center = SwingUtilities.convertPoint(target, center, layoutConstraints.window);
        Rectangle windowBounds = layoutConstraints.windowBounds;
        if (center.y < windowBounds.height / 4) {
            return Alignment.SOUTH;
        }
        if (center.y > 3 * windowBounds.height / 4) {
            return Alignment.NORTH;
        }
        if (center.x - ((LayoutConstraints)layoutConstraints).tooltipBounds.width / 2 < 0) {
            return Alignment.EAST;
        }
        if (center.x + ((LayoutConstraints)layoutConstraints).tooltipBounds.width / 2 > windowBounds.width) {
            return Alignment.WEST;
        }
        return Alignment.SOUTH;
    }

    private static LayoutConstraints calculateLayoutConstraints(ToolTipContext context, Point p) {
        Window window = DarkUIUtil.getWindow(context.getTarget());
        Rectangle screenBounds = DarkUIUtil.getScreenBounds(context.getTarget(), p);
        Rectangle windowBounds = window.getBounds();
        JToolTip toolTip = context.getToolTip();
        Rectangle tooltipBounds = new Rectangle(toolTip.getPreferredSize());
        Border tooltipBorder = toolTip.getBorder();
        Insets layoutInsets = tooltipBorder instanceof AlignableTooltipBorder ? ((AlignableTooltipBorder)((Object)tooltipBorder)).getAlignmentInsets(toolTip) : new Insets(0, 0, 0, 0);
        return new LayoutConstraints(tooltipBounds, windowBounds, window, screenBounds, layoutInsets);
    }

    private static Point tryAlignments(Alignment[] alignments, ToolTipContext context, Point p, LayoutConstraints layoutConstraints, BiConsumer<ToolTipContext, Alignment> setter, boolean centerHorizontally, boolean centerVertically) {
        Point pos = null;
        for (Alignment a : alignments) {
            if ((centerHorizontally || centerVertically) && a.isDiagonal() && (pos = ToolTipUtil.tryPosition(a, context, p, layoutConstraints, setter, centerHorizontally, centerVertically)) != null || (pos = ToolTipUtil.tryPosition(a, context, p, layoutConstraints, setter, false, false)) != null) break;
        }
        return pos;
    }

    private static Alignment[] getAlignments(Alignment start) {
        Alignment opposite = start.opposite();
        Alignment clockwise = start.clockwise();
        Alignment anticlockwise = start.anticlockwise();
        return new Alignment[]{start, anticlockwise, clockwise, opposite, opposite.clockwise(), opposite.anticlockwise(), anticlockwise.anticlockwise(), clockwise.clockwise()};
    }

    private static Point tryPosition(Alignment a, ToolTipContext context, Point p, LayoutConstraints layoutConstraints, BiConsumer<ToolTipContext, Alignment> setter, boolean centerHorizontally, boolean centerVertically) {
        setter.accept(context, a);
        context.setCenterAlignment(a);
        context.updateToolTip();
        Point pos = context.getToolTipLocation(p, null, centerHorizontally, centerVertically);
        Point screenPos = new Point(pos.x, pos.y);
        SwingUtilities.convertPointToScreen(screenPos, context.getTarget());
        layoutConstraints.tooltipBounds.setLocation(screenPos);
        if (!ToolTipUtil.fits(layoutConstraints)) {
            pos = null;
        }
        return pos;
    }

    private static boolean fits(LayoutConstraints layoutConstraints) {
        Rectangle testRectangle = layoutConstraints.testRectangle();
        if (Objects.equals(layoutConstraints.windowBounds, layoutConstraints.screenBoundary)) {
            return SwingUtilities.isRectangleContainingRectangle(layoutConstraints.screenBoundary, testRectangle);
        }
        return SwingUtilities.isRectangleContainingRectangle(layoutConstraints.windowBounds, testRectangle) && SwingUtilities.isRectangleContainingRectangle(layoutConstraints.screenBoundary, testRectangle);
    }

    private static ToolTipContext getToolTipContext(JToolTip tooltip) {
        Object context = tooltip.getClientProperty("JToolTip.toolTipContext");
        if (context instanceof ToolTipContext) {
            return (ToolTipContext)context;
        }
        context = tooltip.getComponent().getClientProperty("JToolTip.toolTipContext");
        if (context instanceof ToolTipContext) {
            return (ToolTipContext)context;
        }
        Object style = tooltip.getComponent().getClientProperty("JToolTip.style");
        if (ToolTipStyle.BALLOON.equals(ToolTipStyle.parse(style))) {
            return ToolTipContext.getDefaultContext();
        }
        return null;
    }

    public static void moveToolTip(JToolTip toolTip, LocationResult result, JComponent target) {
        Window window = DarkUIUtil.getWindow(toolTip);
        if (window == null) {
            return;
        }
        if (result.isRelative) {
            SwingUtilities.convertPointToScreen(result.point, target);
        }
        WindowUtil.moveWindow(window, toolTip, ((LocationResult)result).point.x, ((LocationResult)result).point.y);
    }

    private static class LocationResult {
        private final Point point;
        private final boolean isRelative;

        private LocationResult(Point point, boolean isRelative) {
            this.point = point;
            this.isRelative = isRelative;
        }
    }

    private static final class LayoutConstraints {
        private final Rectangle tooltipBounds;
        private final Rectangle windowBounds;
        private final Window window;
        private final Rectangle screenBoundary;
        private final Insets layoutInsets;

        private LayoutConstraints(Rectangle tooltipBounds, Rectangle windowBounds, Window window, Rectangle screenBoundary, Insets layoutInsets) {
            this.tooltipBounds = tooltipBounds;
            this.windowBounds = windowBounds;
            this.window = window;
            this.screenBoundary = screenBoundary;
            this.layoutInsets = layoutInsets;
        }

        public Rectangle testRectangle() {
            return DarkUIUtil.applyInsets(new Rectangle(this.tooltipBounds), this.layoutInsets);
        }

        public String toString() {
            return "LayoutConstraints{tooltipBounds=" + this.tooltipBounds + ", layoutInsets=" + this.layoutInsets + ", screenBoundary=" + this.screenBoundary + ", windowBounds=" + this.windowBounds + ", window=" + this.window + '}';
        }
    }
}

