/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.layout;

import com.github.weisj.darklaf.components.HoveringPanel;
import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.components.border.DarkBorders;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public final class LayoutHelper {
    private LayoutHelper() {
        throw new IllegalArgumentException("Utility class");
    }

    public static int getDefaultSpacing() {
        return 5;
    }

    public static Border createEmptyBorder(Insets ins) {
        return BorderFactory.createEmptyBorder(ins.top, ins.left, ins.bottom, ins.right);
    }

    public static Border createEmptyContainerBorder() {
        int pad = LayoutHelper.getDefaultSpacing();
        return BorderFactory.createEmptyBorder(pad, pad, pad, pad);
    }

    public static Insets createEmptyContainerInsets() {
        int pad = LayoutHelper.getDefaultSpacing();
        return new Insets(pad, pad, pad, pad);
    }

    public static JComponent createTwoColumnPanel(JComponent[] left, JComponent[] right) {
        return LayoutHelper.createTwoColumnPanel(Arrays.asList(left), Arrays.asList(right));
    }

    public static JComponent createTwoColumnPanel(JComponent[] left, JComponent[] right, GroupLayout.Alignment leftColumn, GroupLayout.Alignment rightColumn) {
        return LayoutHelper.createTwoColumnPanel(Arrays.asList(left), Arrays.asList(right), leftColumn, rightColumn);
    }

    public static JComponent createTwoColumnPanel(List<JComponent> left, List<JComponent> right) {
        return LayoutHelper.createTwoColumnPanel(left, right, GroupLayout.Alignment.TRAILING, GroupLayout.Alignment.LEADING);
    }

    public static JComponent createTwoColumnPanel(List<JComponent> left, List<JComponent> right, GroupLayout.Alignment leftColumn, GroupLayout.Alignment rightColumn) {
        if (left.size() != right.size()) {
            String s = left.size() + " labels supplied for " + right.size() + " fields!";
            throw new IllegalArgumentException(s);
        }
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup verticalLabelGroup = layout.createParallelGroup(leftColumn);
        horizontalGroup.addGroup(verticalLabelGroup);
        GroupLayout.ParallelGroup verticalComponentGroup = layout.createParallelGroup(rightColumn);
        horizontalGroup.addGroup(verticalComponentGroup);
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        layout.setVerticalGroup(verticalGroup);
        int p = -2;
        for (int i = 0; i < left.size(); ++i) {
            JComponent lComp = left.get(i);
            JComponent rComp = right.get(i);
            panel.add(lComp);
            panel.add(rComp);
            ((GroupLayout.Group)verticalLabelGroup).addComponent(lComp, p, p, p);
            ((GroupLayout.Group)verticalComponentGroup).addComponent(rComp, p, p, p);
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lComp, p, p, p).addComponent(rComp, p, p, p));
        }
        return panel;
    }

    public static JComponent createTitledColumn(List<String> titles, List<JComponent> components, int indent) {
        if (titles.size() != components.size()) {
            String s = titles.size() + " labels supplied for " + components.size() + " components!";
            throw new IllegalArgumentException(s);
        }
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupLayout.ParallelGroup parallelGroup = layout.createParallelGroup();
        GroupLayout.SequentialGroup sequentialGroup = layout.createSequentialGroup();
        int p = -2;
        for (int i = 0; i < titles.size(); ++i) {
            JLabel label = new JLabel(titles.get(i));
            JComponent c = components.get(i);
            sequentialGroup.addComponent(label, p, p, p);
            sequentialGroup.addComponent(c, p, p, p);
            parallelGroup.addComponent(label, p, p, p);
            GroupLayout.SequentialGroup sq = layout.createSequentialGroup();
            if (indent >= 0) {
                sq.addGap(indent);
            } else {
                sq.addPreferredGap(label, c, LayoutStyle.ComponentPlacement.INDENT);
            }
            sq.addComponent(c, p, p, p);
            parallelGroup.addGroup(sq);
        }
        layout.setHorizontalGroup(parallelGroup);
        layout.setVerticalGroup(sequentialGroup);
        return panel;
    }

    public static JComponent createPanelWithHoverOverlay(JComponent content, JComponent overlayContent) {
        return LayoutHelper.createPanelWithHoverOverlay(content, overlayContent, Alignment.NORTH_EAST, LayoutHelper.createEmptyContainerInsets());
    }

    public static JComponent createPanelWithHoverOverlay(JComponent content, JComponent overlayContent, Alignment alignment, Insets padding) {
        return LayoutHelper.createPanelWithHoverOverlay(content, overlayContent, (r, c) -> {
            Dimension prefSize = c.getPreferredSize();
            DarkUIUtil.applyInsets(r, padding);
            Point p = alignment.alignInside(prefSize, (Rectangle)r);
            return new Rectangle(p, prefSize);
        });
    }

    public static JComponent createPanelWithHoverOverlay(JComponent content, JComponent overlayContent, BiFunction<Rectangle, JComponent, Rectangle> layoutFunction) {
        HoveringPanel hoveringPanel = new HoveringPanel();
        hoveringPanel.add(overlayContent);
        return LayoutHelper.createPanelWithOverlay(content, hoveringPanel, (r, c) -> {
            hoveringPanel.setVisible(overlayContent.isVisible());
            return (Rectangle)layoutFunction.apply((Rectangle)r, hoveringPanel);
        });
    }

    public static JComponent createPanelWithOverlay(JComponent content, JComponent overlayContent) {
        return LayoutHelper.createPanelWithOverlay(content, overlayContent, Alignment.NORTH_EAST, LayoutHelper.createEmptyContainerInsets());
    }

    public static JComponent createPanelWithOverlay(JComponent content, JComponent overlayContent, Alignment alignment, Insets padding) {
        return LayoutHelper.createPanelWithOverlay(content, overlayContent, (r, c) -> {
            Dimension prefSize = c.getPreferredSize();
            DarkUIUtil.applyInsets(r, padding);
            Point p = alignment.alignInside(prefSize, (Rectangle)r);
            return new Rectangle(p, prefSize);
        });
    }

    public static JComponent createPanelWithOverlay(final JComponent content, final JComponent overlayContent, final BiFunction<Rectangle, JComponent, Rectangle> layoutFunction) {
        return new JLayeredPane(){
            {
                this.add((Component)content, JLayeredPane.DEFAULT_LAYER);
                this.add((Component)overlayContent, (Object)(JLayeredPane.MODAL_LAYER - 1));
            }

            @Override
            public void doLayout() {
                super.doLayout();
                Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                content.setBounds(bounds);
                content.doLayout();
                overlayContent.setBounds((Rectangle)layoutFunction.apply(bounds, overlayContent));
                overlayContent.doLayout();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Dimension contentSize = content.getPreferredSize();
                dim.width = Math.max(dim.width, contentSize.width);
                dim.height = Math.max(dim.height, contentSize.height);
                if (overlayContent.isVisible()) {
                    Rectangle layoutRect = (Rectangle)layoutFunction.apply(new Rectangle(dim), overlayContent);
                    dim.width = Math.max(dim.width, layoutRect.x + layoutRect.width);
                    dim.height = Math.max(dim.height, layoutRect.y + layoutRect.height);
                }
                return dim;
            }
        };
    }

    public static OverlayScrollPane createScrollPaneWithOverlay(JComponent content, JComponent overlayContent) {
        return LayoutHelper.createScrollPaneWithOverlay(content, overlayContent, Alignment.NORTH_EAST, LayoutHelper.createEmptyContainerInsets());
    }

    public static OverlayScrollPane createScrollPaneWithOverlay(JComponent content, JComponent overlayContent, Alignment alignment, Insets padding) {
        return LayoutHelper.createScrollPaneWithOverlay(content, overlayContent, (r, c) -> {
            Dimension prefSize = c.getPreferredSize();
            DarkUIUtil.applyInsets(r, padding);
            Point p = alignment.alignInside(prefSize, (Rectangle)r);
            return new Rectangle(p, prefSize);
        });
    }

    public static OverlayScrollPane createScrollPaneWithHoverOverlay(JComponent content, final JComponent overlayContent, Alignment alignment, Supplier<Insets> paddingSupplier) {
        HoveringPanel hoveringPanel = new HoveringPanel(){

            @Override
            public boolean isVisible() {
                return overlayContent.isVisible();
            }
        };
        hoveringPanel.add(overlayContent);
        return LayoutHelper.createScrollPaneWithOverlay(content, (JComponent)hoveringPanel, alignment, paddingSupplier);
    }

    public static OverlayScrollPane createScrollPaneWithOverlay(JComponent content, JComponent overlayContent, Alignment alignment, Supplier<Insets> paddingSupplier) {
        return LayoutHelper.createScrollPaneWithOverlay(content, overlayContent, (r, c) -> {
            Dimension prefSize = c.getPreferredSize();
            DarkUIUtil.applyInsets(r, (Insets)paddingSupplier.get());
            Point p = alignment.alignInside(prefSize, (Rectangle)r);
            return new Rectangle(p, prefSize);
        });
    }

    public static OverlayScrollPane createScrollPaneWithHoverOverlay(JComponent content, JComponent overlayContent, BiFunction<Rectangle, JComponent, Rectangle> layoutFunction) {
        HoveringPanel hoveringPanel = new HoveringPanel();
        hoveringPanel.add(overlayContent);
        return LayoutHelper.createScrollPaneWithOverlay(content, hoveringPanel, (r, c) -> {
            hoveringPanel.setVisible(overlayContent.isVisible());
            return (Rectangle)layoutFunction.apply((Rectangle)r, hoveringPanel);
        });
    }

    public static OverlayScrollPane createScrollPaneWithOverlay(JComponent content, final JComponent overlayContent, final BiFunction<Rectangle, JComponent, Rectangle> layoutFunction) {
        return new OverlayScrollPane(content){
            {
                super(view);
                this.add((Component)overlayContent, (Object)(JLayeredPane.MODAL_LAYER - 1));
            }

            @Override
            public void doLayout() {
                super.doLayout();
                JViewport viewport = this.getScrollPane().getViewport();
                overlayContent.setBounds((Rectangle)layoutFunction.apply(this.getLayoutRect(((Component)viewport).getWidth(), ((Component)viewport).getHeight()), overlayContent));
                overlayContent.doLayout();
                overlayContent.setVisible(overlayContent.isVisible());
            }

            private Rectangle getLayoutRect(int width, int height) {
                JViewport viewport = this.getScrollPane().getViewport();
                Rectangle viewBounds = new Rectangle(0, 0, width, height);
                viewBounds = SwingUtilities.convertRectangle(viewport, viewBounds, this);
                JScrollBar vertBar = this.getVerticalScrollBar();
                JScrollBar horBar = this.getHorizontalScrollBar();
                if (vertBar != null && vertBar.isVisible()) {
                    viewBounds.width -= vertBar.getWidth();
                }
                if (horBar != null && horBar.isVisible()) {
                    viewBounds.height -= horBar.getHeight();
                }
                return viewBounds;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (overlayContent.isVisible()) {
                    Rectangle layoutRect = (Rectangle)layoutFunction.apply(this.getLayoutRect(dim.width, dim.height), overlayContent);
                    dim.width = Math.max(dim.width, layoutRect.x + layoutRect.width);
                    dim.height = Math.max(dim.height, layoutRect.y + layoutRect.height);
                }
                return dim;
            }
        };
    }

    public static Box createHorizontalBox(int padding, JComponent ... comps) {
        Box box = Box.createHorizontalBox();
        if (comps != null) {
            for (int i = 0; i < comps.length - 1; ++i) {
                box.add(comps[i]);
                box.add(Box.createHorizontalStrut(padding));
            }
            box.add(comps[comps.length - 1]);
        }
        return box;
    }

    public static Box createVerticalBox(int padding, JComponent ... comps) {
        Box box = Box.createVerticalBox();
        if (comps != null) {
            for (int i = 0; i < comps.length - 1; ++i) {
                box.add(comps[i]);
                box.add(Box.createVerticalStrut(padding));
            }
            box.add(comps[comps.length - 1]);
        }
        return box;
    }

    public static JComponent createMultiColumnPanel(List<? extends JComponent> components) {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        GroupLayout.SequentialGroup horizontal = layout.createSequentialGroup();
        GroupLayout.ParallelGroup vertical = layout.createParallelGroup();
        layout.setHorizontalGroup(horizontal);
        layout.setVerticalGroup(vertical);
        for (int i = 0; i < components.size(); ++i) {
            JPanel holder = new JPanel(new BorderLayout());
            if (i > 0) {
                holder.setBorder(DarkBorders.createLeftBorder());
            }
            holder.add(components.get(i));
            horizontal.addComponent(holder);
            vertical.addComponent(holder);
        }
        return panel;
    }
}

