/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.components.chooser.ChooserComponent;
import com.github.weisj.darklaf.ui.colorchooser.SwatchPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.UIManager;

public class PopupColorSwatchChooser
extends SwatchPanel
implements ChooserComponent<Color> {
    private final Function<Color, String> tipTextFunction;
    private Color initial;
    private Consumer<Color> callback;

    public PopupColorSwatchChooser(Color[] colors) {
        this(colors, 5, c -> null);
    }

    public PopupColorSwatchChooser(Color[] colors, Function<Color, String> tipTextFunction) {
        this(colors, 5, tipTextFunction);
    }

    public PopupColorSwatchChooser(Color[] colors, int columns, Function<Color, String> tipTextFunction) {
        this.colors = colors;
        this.tipTextFunction = tipTextFunction;
        this.numSwatches.width = columns;
        this.numSwatches.height = (int)Math.ceil((float)colors.length / (float)this.numSwatches.width);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PopupColorSwatchChooser.this.setSelectedColorFromLocation(e.getX(), e.getY());
            }
        });
    }

    @Override
    public void reset(Color initial, Consumer<Color> callback) {
        this.initial = initial;
        this.callback = callback;
        this.setSelection(-1, -1);
        if (initial != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                if (!this.colors[i].equals(initial)) continue;
                this.setSelection(i);
                break;
            }
        }
    }

    @Override
    public Color getInitial() {
        return this.initial;
    }

    @Override
    public Color getSelected() {
        return this.getSelectedColor();
    }

    @Override
    protected void setSelection(int row, int col) {
        super.setSelection(row, col);
        if (this.callback != null) {
            this.callback.accept(this.getSelectedColor());
        }
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize", this.getLocale());
        this.numSwatches = new Dimension(30, 15);
        this.gap = new Dimension(1, 1);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tipText = this.tipTextFunction.apply(this.getColorForLocation(e.getX(), e.getY()));
        return tipText != null ? tipText : super.getToolTipText(e);
    }

    @Override
    protected void initColors() {
    }
}

