/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public final class DynamicUI {
    private static final Map<Object, List<Consumer<Object>>> listeners = new WeakHashMap<Object, List<Consumer<Object>>>();

    private DynamicUI() {
        throw new IllegalStateException("Utility class");
    }

    public static <T extends Component> T withDynamic(T component, Consumer<T> onUpdateUi) {
        return DynamicUI.registerCallback(component, onUpdateUi, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T registerCallback(T object, Consumer<T> onUpdateUi, boolean invokeOnce) {
        if (invokeOnce) {
            onUpdateUi.accept(object);
        }
        Map<Object, List<Consumer<Object>>> map = listeners;
        synchronized (map) {
            listeners.compute(object, (k, v) -> {
                if (v == null) {
                    return Collections.singletonList(onUpdateUi);
                }
                List res = v.size() == 1 ? new ArrayList(v) : v;
                res.add(onUpdateUi);
                return res;
            });
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void removeCallback(T object, Consumer<T> callback) {
        Map<Object, List<Consumer<Object>>> map = listeners;
        synchronized (map) {
            listeners.compute(object, (k, v) -> {
                if (v == null) {
                    return null;
                }
                if (!v.remove(callback)) {
                    return v;
                }
                if (v.size() == 0) {
                    return null;
                }
                if (v.size() == 1) {
                    return Collections.singletonList((Consumer)v.get(0));
                }
                return v;
            });
        }
    }

    public static <T extends AbstractButton> T withLocalizedText(T comp, String textKey) {
        return (T)DynamicUI.withDynamic(comp, c -> c.setText(UIManager.getString((Object)textKey, c.getLocale())));
    }

    public static <T extends JLabel> T withLocalizedText(T comp, String textKey) {
        return (T)DynamicUI.withDynamic(comp, c -> c.setText(UIManager.getString((Object)textKey, c.getLocale())));
    }

    public static <T extends JComponent> T withLocalizedTooltip(T comp, String tipTextKey) {
        return (T)DynamicUI.withDynamic(comp, c -> c.setToolTipText(UIManager.getString((Object)tipTextKey, c.getLocale())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateComponent(Object component) {
        Map<Object, List<Consumer<Object>>> map = listeners;
        synchronized (map) {
            List<Consumer<Object>> list = listeners.get(component);
            if (list == null) {
                return;
            }
            for (Consumer<Object> action : list) {
                action.accept(component);
            }
        }
    }

    static {
        UIManager.addPropertyChangeListener(e -> {
            String key = e.getPropertyName();
            if ("lookandfeel".equalsIgnoreCase(key)) {
                listeners.keySet().forEach(DynamicUI::updateComponent);
            }
        });
    }
}

