/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.fakelwjgl3ify.SafeRuntimeExit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.eigenraven.lwjgl3ify.relauncher.Downloader;
import me.eigenraven.lwjgl3ify.relauncher.RelauncherConfig;
import me.eigenraven.lwjgl3ify.relauncher.RelauncherUserInterface;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Relauncher {
    static final Logger logger = LogManager.getLogger((String)"Lwjgl3ify/Relauncher");
    static final String[] SYSTEM_PROPERTY_PREFIXES = new String[]{"java.", "os.", "path.", "file.", "line.", "user.", "native.", "com.sun.", "sun.", "awt."};
    static final String[] RECOMMENDED_JAVA_ARGS = "-Dfile.encoding=UTF-8\t-Djava.system.class.loader=com.gtnewhorizons.retrofuturabootstrap.RfbSystemClassLoader\t-Djava.security.manager=allow\t--add-opens\tjava.base/java.io=ALL-UNNAMED\t--add-opens\tjava.base/java.lang.invoke=ALL-UNNAMED\t--add-opens\tjava.base/java.lang.ref=ALL-UNNAMED\t--add-opens\tjava.base/java.lang.reflect=ALL-UNNAMED\t--add-opens\tjava.base/java.lang=ALL-UNNAMED\t--add-opens\tjava.base/java.net.spi=ALL-UNNAMED\t--add-opens\tjava.base/java.net=ALL-UNNAMED\t--add-opens\tjava.base/java.nio.channels=ALL-UNNAMED\t--add-opens\tjava.base/java.nio.charset=ALL-UNNAMED\t--add-opens\tjava.base/java.nio.file=ALL-UNNAMED\t--add-opens\tjava.base/java.nio=ALL-UNNAMED\t--add-opens\tjava.base/java.text=ALL-UNNAMED\t--add-opens\tjava.base/java.time.chrono=ALL-UNNAMED\t--add-opens\tjava.base/java.time.format=ALL-UNNAMED\t--add-opens\tjava.base/java.time.temporal=ALL-UNNAMED\t--add-opens\tjava.base/java.time.zone=ALL-UNNAMED\t--add-opens\tjava.base/java.time=ALL-UNNAMED\t--add-opens\tjava.base/java.util.concurrent.atomics=ALL-UNNAMED\t--add-opens\tjava.base/java.util.concurrent.locks=ALL-UNNAMED\t--add-opens\tjava.base/java.util.jar=ALL-UNNAMED\t--add-opens\tjava.base/java.util.zip=ALL-UNNAMED\t--add-opens\tjava.base/java.util=ALL-UNNAMED\t--add-opens\tjava.base/jdk.internal.loader=ALL-UNNAMED\t--add-opens\tjava.base/jdk.internal.misc=ALL-UNNAMED\t--add-opens\tjava.base/jdk.internal.ref=ALL-UNNAMED\t--add-opens\tjava.base/jdk.internal.reflect=ALL-UNNAMED\t--add-opens\tjava.base/sun.nio.ch=ALL-UNNAMED\t--add-opens\tjava.desktop/com.sun.imageio.plugins.png=ALL-UNNAMED\t--add-opens\tjava.desktop/sun.awt.image=ALL-UNNAMED\t--add-opens\tjava.desktop/sun.awt=ALL-UNNAMED\t--add-opens\tjava.sql.rowset/javax.sql.rowset.serial=ALL-UNNAMED\t--add-opens\tjdk.dynalink/jdk.dynalink.beans=ALL-UNNAMED\t--add-opens\tjdk.naming.dns/com.sun.jndi.dns=ALL-UNNAMED,java.naming".split("\t");
    final Path osCache;
    final Path mavenDownloadPath;
    final String[] args;
    final String gameVersion;
    final Downloader downloader;
    final RelauncherUserInterface gui;
    Path forgePatchesJarPath;

    public void runtimeExit(int exitCode) {
        SafeRuntimeExit.exitRuntime(exitCode);
    }

    public Relauncher(String[] args, String gameVersion) {
        Path cacheDir;
        this.args = args;
        this.gameVersion = gameVersion;
        String userHome = System.getProperty("user.home");
        String system = System.getProperty("os.name").toLowerCase();
        try {
            if (system.contains("win")) {
                String temp = System.getenv("TEMP");
                String localAppData = System.getenv("LOCALAPPDATA");
                cacheDir = temp != null ? Paths.get(temp, "lwjgl3ify") : (localAppData != null ? Paths.get(localAppData, "Temp", "lwjgl3ify") : Paths.get(userHome, "AppData", "Local", "Temp", "lwjgl3ify"));
            } else {
                String xdgCacheHome;
                cacheDir = system.contains("mac") ? Paths.get(userHome, "Library", "Caches", "lwjgl3ify") : ((xdgCacheHome = System.getenv("XDG_CACHE_HOME")) == null ? Paths.get(userHome, ".cache", "lwjgl3ify") : Paths.get(xdgCacheHome, "lwjgl3ify"));
            }
        }
        catch (InvalidPathException e) {
            cacheDir = system.contains("win") ? Paths.get(userHome, "AppData", "Local", "Temp", "lwjgl3ify") : Paths.get(userHome, ".cache", "lwjgl3ify");
            logger.warn("An error occurred while the lwjgl3ify relauncher cache path was created. The environment variable TEMP or LOCALAPPDATA could be set incorrectly. Using the default cache location: {}", new Object[]{cacheDir, e});
        }
        this.osCache = cacheDir;
        String mavenDownloadRoot = System.getProperty("lwjgl3ify.relauncher.mavenDownloadRoot", "");
        Path mavenDownloadPath = mavenDownloadRoot.isEmpty() ? this.osCache.resolve("maven") : Paths.get(mavenDownloadRoot, new String[0]);
        if (!Files.isDirectory(mavenDownloadPath, new LinkOption[0])) {
            try {
                Files.createDirectories(mavenDownloadPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.fatal("Could not create Maven download cache at {}", new Object[]{mavenDownloadPath, e});
                FMLCommonHandler.instance().exitJava(1, false);
            }
        }
        this.mavenDownloadPath = mavenDownloadPath;
        RelauncherConfig.load();
        this.gui = new RelauncherUserInterface(this);
        this.downloader = new Downloader(mavenDownloadPath);
        this.downloader.loadTasks();
        int dlTasks = this.downloader.remainingTasks();
        if (dlTasks > 0) {
            logger.info("We need to download {} libraries into the cache at {}", new Object[]{dlTasks, mavenDownloadPath});
            this.gui.downloadWithGui(this.downloader);
        } else {
            logger.info("All libraries found in the cache at {}", new Object[]{mavenDownloadPath});
        }
    }

    public List<String> createClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            byte[] forgePatchesData = IOUtils.toByteArray((InputStream)Objects.requireNonNull(Relauncher.class.getResourceAsStream("forgePatches.zip"), "missing bundled forgePatches jar"));
            String forgePatchesDigest = DigestUtils.sha256Hex((byte[])forgePatchesData);
            Path jarsDir = this.mavenDownloadPath.getParent().resolve("jars");
            Files.createDirectories(jarsDir, new FileAttribute[0]);
            Path jarFile = jarsDir.resolve("forgePatches-" + forgePatchesDigest + ".jar");
            if (!Files.exists(jarFile, new LinkOption[0])) {
                logger.info("Extracting bundled early classpath libraries to {}", new Object[]{jarFile});
                Files.write(jarFile, forgePatchesData, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            } else {
                logger.info("Using previously extracted bundled early classpath libraries from {}", new Object[]{jarFile});
            }
            classpath.add(jarFile.toString());
            this.forgePatchesJarPath = jarFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Path cpFile : this.downloader.jarPaths()) {
            if (!Files.exists(cpFile, new LinkOption[0])) continue;
            classpath.add(cpFile.toAbsolutePath().toString());
        }
        return classpath;
    }

    private static long getCurrentPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String combinedPidHostname = runtime.getName();
        String[] parts = combinedPidHostname.split("@", 2);
        return Integer.parseInt(parts[0]);
    }

    public void run() throws IOException {
        Path myJarPath;
        this.gui.startSettingsIfNeeded();
        if (!this.gui.runClicked) {
            this.runtimeExit(0);
            return;
        }
        URL myJarUrl = Relauncher.class.getProtectionDomain().getCodeSource().getLocation();
        while ("jar".equalsIgnoreCase(myJarUrl.getProtocol())) {
            String str = myJarUrl.toString();
            myJarUrl = new URL(str.substring(4, str.lastIndexOf(33)));
        }
        try {
            myJarPath = Paths.get(myJarUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList(RECOMMENDED_JAVA_ARGS));
        cmd.addAll(RelauncherConfig.config.toJvmArgs());
        cmd.add("-cp");
        cmd.add(StringUtils.join(this.createClasspath(), (char)File.pathSeparatorChar));
        block7: for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
            if (prop.getKey() == null || prop.getValue() == null) continue;
            String key = prop.getKey().toString();
            for (String systemPrefix : SYSTEM_PROPERTY_PREFIXES) {
                if (key.startsWith(systemPrefix)) continue block7;
            }
            String value = prop.getValue().toString();
            cmd.add("-D" + key + "=" + value);
        }
        cmd.add("com.gtnewhorizons.retrofuturabootstrap.Main");
        cmd.addAll(Arrays.asList("--version", this.gameVersion, "--gameDir", Launch.minecraftHome.toString(), "--assetsDir", Launch.assetsDir.toString(), "--tweakClass", "cpw.mods.fml.common.launcher.FMLTweaker"));
        cmd.addAll(Arrays.asList(this.args));
        Path argFile = Files.createTempFile("lwjgl3ify-relaunch-", ".arg", new FileAttribute[0]);
        Files.write(argFile, (Iterable<? extends CharSequence>)cmd.stream().map(c -> '\"' + StringEscapeUtils.escapeJava((String)c) + '\"').collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
        ArrayList<String> bootstrapCmd = new ArrayList<String>();
        String[] javas = RelauncherConfig.config.javaInstallationsCache;
        int javaIdx = RelauncherConfig.config.javaInstallation;
        String javaPath = javaIdx < 0 || javaIdx >= javas.length ? (SystemUtils.IS_OS_WINDOWS ? "javaw" : "java") : javas[javaIdx];
        bootstrapCmd.add(javaPath);
        if (RelauncherConfig.config.forwardLogs) {
            bootstrapCmd.add("@" + argFile);
        } else {
            bootstrapCmd.add("-Xms16M");
            bootstrapCmd.add("-Xmx256M");
            bootstrapCmd.add("-cp");
            bootstrapCmd.add(this.forgePatchesJarPath + File.pathSeparator + myJarPath);
            bootstrapCmd.add("me.eigenraven.lwjgl3ify.relauncherstub.RelauncherStubMain");
            bootstrapCmd.add(Long.toString(Relauncher.getCurrentPid()));
            bootstrapCmd.add("true");
            bootstrapCmd.add(javaPath);
            bootstrapCmd.add(argFile.toString());
        }
        ProcessBuilder pb = new ProcessBuilder(bootstrapCmd);
        pb.inheritIO();
        if (!RelauncherConfig.config.forwardLogs) {
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        }
        logger.info("Starting relaunched process using args {}", new Object[]{bootstrapCmd});
        Process p = pb.start();
        if (RelauncherConfig.config.forwardLogs) {
            while (p.isAlive()) {
                try {
                    p.waitFor();
                    break;
                }
                catch (InterruptedException e) {
                }
            }
            this.runtimeExit(p.exitValue());
        } else {
            try {
                p.getInputStream().read(new byte[6]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.runtimeExit(0);
        }
    }
}

