/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util.cache;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;

public class SoftCache<K, V extends Cacheable<K>> {
    private final Map<K, SoftReference<V>> cache = new WeakHashMap<K, SoftReference<V>>();

    public V get(K key) {
        Reference reference = this.cache.get(key);
        if (reference == null) {
            return null;
        }
        Cacheable value = (Cacheable)reference.get();
        if (value == null) {
            this.cache.remove(key);
        }
        return (V)value;
    }

    public void put(K key, V value) {
        if (value != null) {
            this.cache.put(key, new SoftReference<V>(value));
            value.setCacheKey(key);
        } else {
            this.cache.remove(key);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public static interface Cacheable<K> {
        public void setCacheKey(K var1);
    }
}

