/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.titledborder;

import com.github.weisj.darklaf.components.border.MutableLineBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;

public class DarkTitledBorder
extends MutableLineBorder
implements UIResource {
    public DarkTitledBorder() {
        super(1, 0, 0, 0, null);
        this.setColor(UIManager.getColor("TitledBorder.borderColor"));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.checkInsets(c);
        super.paintBorder(c, g, x, y, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        this.checkInsets(c);
        return super.getBorderInsets(c, insets);
    }

    protected void checkInsets(Component c) {
        JComponent component;
        Border border;
        this.setInsets(1, 0, 0, 0);
        if (c instanceof JComponent && (border = (component = (JComponent)c).getBorder()) instanceof TitledBorder) {
            boolean onTop;
            String text = ((TitledBorder)border).getTitle();
            int pos = ((TitledBorder)border).getTitlePosition();
            boolean bl = onTop = pos == 1 || pos == 3 || pos == 2 || pos == 0;
            if (text == null || text.isEmpty() || !onTop) {
                this.setInsets(1, 1, 1, 1);
            }
        }
    }
}

