/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFramePopup;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.components.tabframe.TabFrameUI;
import com.github.weisj.darklaf.ui.util.DnDUtil;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;

public class TabFrameTransferHandler
extends TransferHandler
implements DropTargetListener,
SwingConstants {
    private static final Logger LOGGER = LogUtil.getLogger(TabFrameTransferHandler.class);
    private static final String MIME_TYPE = "application/x-java-jvm-local-objectref;class=" + TabTransferData.class.getName();
    private static TabFrameDragGestureRecognizer recognizer = null;
    private final Timer timer;
    private final Timer startTimer;
    protected Point mouseLocation;
    private DataFlavor tabFlavor;
    private TabTransferable currentTransferable;
    private JTabFrame lastTabFrame;

    public TabFrameTransferHandler() {
        try {
            this.tabFlavor = new DataFlavor(MIME_TYPE);
        }
        catch (ClassNotFoundException ignored) {
            LOGGER.severe("TabFrame DnD isn't available. Couldn't find MimeType: " + MIME_TYPE);
        }
        this.timer = new Timer(100, e -> {
            if (this.lastTabFrame != null) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, this.lastTabFrame);
                DropTargetDragEvent evt = new DropTargetDragEvent(this.lastTabFrame.getDropTarget().getDropTargetContext(), p, 2, 2);
                this.dragOver(evt);
            }
        });
        this.timer.setRepeats(true);
        this.startTimer = new Timer(200, e -> {
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        });
        this.startTimer.setRepeats(false);
    }

    private TabFrameUI getUI(Component c) {
        if (c instanceof JTabFrame) {
            return ((JTabFrame)c).getUI();
        }
        return null;
    }

    protected JTabFrame.TabFramePosition getDropPosition(Point p, JTabFrame tabFrame) {
        return this.getUI(tabFrame).getDropPosition(tabFrame, p);
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int a) {
        int srcActions = this.getSourceActions(comp);
        int action = a;
        if (!(e instanceof MouseEvent) || action != 1 && action != 2 && action != 0x40000000 || (srcActions & action) == 0) {
            action = 0;
        }
        if (action != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new TabFrameDragGestureRecognizer(new TabbedPaneDragHandler());
            }
            recognizer.gestured(comp, (MouseEvent)e, srcActions, action);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        TabTransferable t;
        e.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
        this.mouseLocation = e.getLocation();
        Component c = e.getDropTargetContext().getComponent();
        JTabFrame destTabFrame = (JTabFrame)c;
        TabFrameUI ui = this.getUI(destTabFrame);
        if (ui != null && (t = this.currentTransferable) != null) {
            JTabFrame.TabFramePosition tab = this.getDropPosition(this.mouseLocation, destTabFrame);
            if (tab.getAlignment() == null) {
                ui.clearTargetIndicator();
            } else {
                try {
                    JTabFrame sourceTab = this.currentTransferable.transferData.sourceTabFrame;
                    int sourceIndex = this.currentTransferable.transferData.tabIndex;
                    Alignment sourceAlign = this.currentTransferable.transferData.tabAlignment;
                    int w = this.getUI(sourceTab).getTabWidth(sourceTab, sourceAlign, sourceIndex);
                    int h = this.getUI(sourceTab).getTabHeight(sourceTab, sourceAlign, sourceIndex);
                    ui.setDropSize(w, h);
                    ui.setTargetIndicator(tab.getAlignment(), tab.getIndex());
                }
                catch (IndexOutOfBoundsException ex) {
                    ui.clearTargetIndicator();
                }
            }
        }
        this.lastTabFrame = destTabFrame;
        this.startTimer.restart();
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasTabFlavor(flavors);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    protected boolean hasTabFlavor(DataFlavor[] flavors) {
        if (this.tabFlavor == null) {
            return false;
        }
        for (DataFlavor flavor : flavors) {
            if (!this.tabFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected void selectTab(JTabFrame tabbedPane, Alignment a, int index) {
        SwingUtilities.invokeLater(() -> tabbedPane.toggleTab(a, index, true));
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        TabFrameUI ui = this.getUI(c);
        if (ui != null) {
            ui.clearTargetIndicator();
        }
        this.lastTabFrame = (JTabFrame)c;
        this.startTimer.start();
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        TabFrameUI ui = this.getUI(c);
        if (ui != null) {
            ui.clearTargetIndicator();
        }
        this.timer.stop();
        this.startTimer.stop();
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.timer.stop();
        this.startTimer.stop();
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        boolean successful = false;
        if (this.hasTabFlavor(t.getTransferDataFlavors()) && this.mouseLocation != null) {
            try {
                JTabFrame tabFrame = (JTabFrame)c;
                JTabFrame.TabFramePosition tab = this.getDropPosition(this.mouseLocation, tabFrame);
                Alignment a = tab.getAlignment();
                int index = tab.getIndex();
                TabTransferData td = (TabTransferData)t.getTransferData(this.tabFlavor);
                if (tabFrame == td.sourceTabFrame && td.tabAlignment == a && index >= td.tabIndex) {
                    --index;
                }
                if (tabFrame == td.sourceTabFrame && a == td.tabAlignment && ++index == td.tabIndex) {
                    if (td.wasSelected) {
                        this.selectTab(td.sourceTabFrame, a, index);
                    }
                    return false;
                }
                if (a == null || index < 0 || index > tabFrame.getTabCountAt(a)) {
                    return false;
                }
                TabFrameTab tabComp = td.sourceTabFrame.getTabComponentAt(td.tabAlignment, td.tabIndex);
                Component popupComp = td.sourceTabFrame.getPopupComponentAt(td.tabAlignment, td.tabIndex);
                td.sourceTabFrame.removeTab(td.tabAlignment, td.tabIndex);
                tabFrame.insertTab((TabFramePopup)((Object)popupComp), tabComp, a, index);
                if (td.wasSelected) {
                    tabFrame.toggleTab(a, index, true);
                }
                SwingUtilities.invokeLater(() -> td.tab.getComponent().repaint());
                successful = true;
                TabFrameUI ui = this.getUI(c);
                if (ui != null) {
                    ui.clearTargetIndicator();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Couldn't import tab data", e);
            }
        }
        return successful;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    protected Transferable createTransferable(JComponent c, DragGestureEvent dge) {
        JTabFrame tabFrame = (JTabFrame)c;
        if (tabFrame.isInTransfer()) {
            this.currentTransferable = new TabTransferable(tabFrame, tabFrame.getTransferInfo());
        } else {
            JTabFrame.TabFramePosition ind = this.getUI(tabFrame).getTabIndexAt(tabFrame, dge.getDragOrigin());
            tabFrame.initTransfer(ind.getAlignment(), ind.getIndex());
            this.currentTransferable = new TabTransferable(tabFrame, ind);
        }
        TabFrameUI ui = this.getUI(c);
        this.createDragImage(ui);
        Alignment a = this.currentTransferable.transferData.tabAlignment;
        int index = this.currentTransferable.transferData.tabIndex;
        ui.setSourceIndicator(a, index);
        this.startTimer.start();
        this.lastTabFrame = this.currentTransferable.transferData.sourceTabFrame;
        return this.currentTransferable;
    }

    protected void createDragImage(TabFrameUI ui) {
        Component comp = this.currentTransferable.transferData.tab.getComponent();
        BufferedImage tabImage = DnDUtil.createDragImage(comp, 2, ui.getDragBorderColor());
        int w = ((Image)tabImage).getWidth(comp);
        int h = ((Image)tabImage).getHeight(comp);
        this.setDragImageOffset(new Point(w / 2, h / 2));
        this.setDragImage(tabImage);
    }

    public class TabTransferable
    implements Transferable {
        private final TabTransferData transferData;

        public TabTransferable(JTabFrame tabFrame, JTabFrame.TabFramePosition ind) {
            this.transferData = new TabTransferData(tabFrame, ind.getAlignment(), ind.getIndex());
        }

        public TabFrameTab getTab() {
            return this.transferData.tab;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (TabFrameTransferHandler.this.tabFlavor == null) {
                return new DataFlavor[0];
            }
            return new DataFlavor[]{TabFrameTransferHandler.this.tabFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return TabFrameTransferHandler.this.tabFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferData;
        }
    }

    protected static class TabFrameDragGestureRecognizer
    extends DragGestureRecognizer {
        protected TabFrameDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    protected class TabbedPaneDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        protected TabbedPaneDragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            TabFrameTransferHandler th = (TabFrameTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c, dge);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image im = th.getDragImage();
                    if (im == null) {
                        dge.startDrag(Cursor.getDefaultCursor(), t, this);
                    } else {
                        dge.startDrag(Cursor.getDefaultCursor(), im, th.getDragImageOffset(), t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                ((TabFrameTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                ((TabFrameTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
            TabFrameUI ui = TabFrameTransferHandler.this.getUI(TabFrameTransferHandler.this.currentTransferable.transferData.sourceTabFrame);
            if (ui != null) {
                ui.clearSourceIndicator();
                ui.clearTargetIndicator();
            }
            if (!dsde.getDropSuccess() && TabFrameTransferHandler.this.currentTransferable.transferData.wasSelected) {
                TabFrameTransferHandler.this.selectTab(TabFrameTransferHandler.this.currentTransferable.transferData.sourceTabFrame, TabFrameTransferHandler.this.currentTransferable.transferData.tabAlignment, TabFrameTransferHandler.this.currentTransferable.transferData.tabIndex);
            }
            TabFrameTransferHandler.this.currentTransferable.transferData.sourceTabFrame.endTransfer();
            TabFrameTransferHandler.this.currentTransferable = null;
        }
    }

    public static class TabTransferData {
        private final JTabFrame sourceTabFrame;
        private final int tabIndex;
        private final Alignment tabAlignment;
        private final TabFrameTab tab;
        private final boolean wasSelected;

        public TabTransferData(JTabFrame tabbedPane, Alignment tabAlignment, int tabIndex) {
            this.sourceTabFrame = tabbedPane;
            this.tabAlignment = tabAlignment;
            this.tabIndex = tabIndex;
            this.tab = tabbedPane.getTabComponentAt(tabAlignment, tabIndex);
            this.wasSelected = this.tab.isSelected();
        }
    }

    public static class UIResource
    extends TabFrameTransferHandler {
    }
}

