/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class DarkSplitPaneDividerPainter {
    protected final Icon verticalSplit;
    protected final Icon horizontalSplit;
    protected final Color borderColor;
    private final DarkSplitPaneUI ui;

    public DarkSplitPaneDividerPainter(DarkSplitPaneUI ui) {
        this.ui = ui;
        this.verticalSplit = UIManager.getIcon("SplitPane.verticalGlue.icon");
        this.horizontalSplit = UIManager.getIcon("SplitPane.horizontalGlue.icon");
        this.borderColor = UIManager.getColor("SplitPane.dividerLineColor");
    }

    public void paint(Component c, Graphics g, int x, int y, int w, int h) {
        JSplitPane splitPane = this.ui.getSplitPane();
        if (splitPane == null) {
            return;
        }
        boolean paintBorder = this.ui.getStyle().isPaintBorder();
        if (splitPane.getOrientation() == 0) {
            Icon icon = this.getVerticalSplitIcon();
            icon.paintIcon(c, g, x + (w - icon.getIconWidth()) / 2, y + (h - icon.getIconHeight()) / 2);
            if (paintBorder) {
                g.setColor(this.borderColor);
                g.fillRect(x, y, w, 1);
                g.fillRect(x, y + h - 1, w, 1);
            }
        } else {
            Icon icon = this.getHorizontalSplitIcon();
            icon.paintIcon(c, g, x + (w - icon.getIconWidth()) / 2, y + (h - icon.getIconHeight()) / 2);
            if (paintBorder) {
                g.setColor(this.borderColor);
                g.fillRect(x, y, 1, h);
                g.fillRect(x + w - 1, y, 1, h);
            }
        }
    }

    protected Icon getVerticalSplitIcon() {
        return this.verticalSplit;
    }

    protected Icon getHorizontalSplitIcon() {
        return this.horizontalSplit;
    }
}

