/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellBorderUIResource;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.UIManager;

public class DarkTableCellFocusBorder
extends DarkCellBorderUIResource {
    protected final Color rowBorderColor = UIManager.getColor("Table.focusRowBorderColor");
    protected final Color borderColor = UIManager.getColor("Table.focusBorderColor");

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        if (DarkTableCellFocusBorder.isRowFocusBorder(c)) {
            g.setColor(this.rowBorderColor);
            g.fillRect(0, 0, width, 1);
            g.fillRect(0, height - 1, width, 1);
            if (DarkTableCellFocusBorder.forcePaintLeft(c)) {
                g.fillRect(0, 0, 1, height);
            }
            if (DarkTableCellFocusBorder.forcePaintRight(c)) {
                g.fillRect(width - 1, 0, 1, height);
            }
        } else {
            g.setColor(this.borderColor);
            PaintUtil.drawRect(g, 0, 0, width, height, 1);
        }
    }

    public static boolean isRowFocusBorder(Component c) {
        return PropertyUtil.getBooleanProperty(c, "JTable.rowFocusBorder");
    }

    protected static boolean forcePaintLeft(Component c) {
        return PropertyUtil.getBooleanProperty(c, "JTable.forcePaintLeft");
    }

    protected static boolean forcePaintRight(Component c) {
        return PropertyUtil.getBooleanProperty(c, "JTable.forcePaintRight");
    }
}

