/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.ui.colorchooser.SwatchPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.UIManager;

class RecentSwatchPanel
extends SwatchPanel {
    private Color defaultRecentColor;

    RecentSwatchPanel() {
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize", this.getLocale());
        this.numSwatches = new Dimension(30, 5);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        this.defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = this.defaultRecentColor;
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Color color = this.getColorForLocation(e.getX(), e.getY());
        if (color == null || color.equals(this.defaultRecentColor)) {
            return null;
        }
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public void setMostRecentColor(Color c) {
        if (Objects.equals(this.colors[0], c)) {
            return;
        }
        System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
        this.colors[0] = c;
        this.repaint();
    }
}

