/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class ImageUtil {
    private ImageUtil() {
    }

    @NotNull
    public static BufferedImage createCompatibleTransparentImage(@NotNull Graphics2D g, double width, double height) {
        AffineTransform at = g.getTransform();
        return new BufferedImage((int)Math.ceil(GeometryUtil.scaleXOfTransform(at) * width), (int)Math.ceil(GeometryUtil.scaleYOfTransform(at) * height), 3);
    }

    @NotNull
    public static BufferedImage createLuminosityBuffer(@NotNull Graphics2D g, double width, double height) {
        AffineTransform at = g.getTransform();
        return new BufferedImage((int)Math.ceil(GeometryUtil.scaleXOfTransform(at) * width), (int)Math.ceil(GeometryUtil.scaleYOfTransform(at) * height), 10);
    }

    public static int[] getINT_RGBA_DataBank(@NotNull WritableRaster raster) {
        DataBufferInt dstDB = (DataBufferInt)raster.getDataBuffer();
        return dstDB.getBankData()[0];
    }

    public static int getINT_RGBA_DataOffset(@NotNull WritableRaster raster) {
        DataBufferInt dstDB = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)raster.getSampleModel();
        return dstDB.getOffset() + sppsm.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
    }

    public static int getINT_RGBA_DataAdjust(@NotNull WritableRaster raster) {
        return ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride() - raster.getWidth();
    }
}

