/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitbutton;

import com.github.weisj.darklaf.ui.WidgetPopupHelper;
import com.github.weisj.darklaf.ui.splitbutton.DarkSplitButtonUI;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DarkSplitButtonListener
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    private final DarkSplitButtonUI ui;

    public DarkSplitButtonListener(DarkSplitButtonUI ui) {
        this.ui = ui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ui.splitButton && this.ui.useArrowButton()) {
            return;
        }
        JPopupMenu actionMenu = this.ui.splitButton.getActionMenu();
        if (actionMenu.isVisible()) {
            actionMenu.setVisible(false);
        } else {
            boolean splitButton = e.getSource() == this.ui.splitButton;
            actionMenu.setPreferredSize(null);
            Dimension size = actionMenu.getPreferredSize();
            Rectangle popupBounds = WidgetPopupHelper.getPopupBounds(this.ui.splitButton, size, this.ui.splitButton.getSize(), splitButton, !splitButton);
            if (splitButton) {
                actionMenu.setPreferredSize(popupBounds.getSize());
            }
            actionMenu.show(this.ui.splitButton, popupBounds.x, popupBounds.y);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("addedAction".equals(key) || "removedAction".equals(key)) {
            this.ui.updateDefaultAction();
            this.ui.splitButton.doLayout();
            this.ui.splitButton.repaint();
        } else if ("JButton.thin".equals(key)) {
            this.ui.updateArrowMargin();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.ui.splitButton.repaint();
        if (!this.ui.splitButton.hasFocus() && this.ui.arrowButton.isRequestFocusEnabled() && this.ui.arrowButton.getModel().isPressed()) {
            this.ui.splitButton.requestFocusInWindow();
        }
    }
}

