/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.menu;

import com.github.weisj.darklaf.compatibility.MenuItemLayoutHelper;
import com.github.weisj.darklaf.delegate.MouseInputDelegate;
import com.github.weisj.darklaf.ui.menu.DarkMenuItemUIBase;
import com.github.weisj.darklaf.ui.menu.MenuItemUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class DarkMenuUI
extends BasicMenuUI
implements MenuItemUI {
    protected int acceleratorTextOffset;
    protected boolean useEvenHeight;
    protected Icon arrowIconHover;
    protected Icon arrowIconDisabled;
    protected JMenu menu;

    public static ComponentUI createUI(JComponent x) {
        return new DarkMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.menu = (JMenu)c;
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        MenuItemLayoutHelper.uninstall(this.menuItem);
        super.uninstallUI(c);
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputDelegate(super.createMouseInputListener(c)){
            private boolean pressed;
            private boolean wasEnabled;
            {
                this.pressed = false;
                this.wasEnabled = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!DarkMenuUI.this.menu.isTopLevelMenu()) {
                    MenuElement[] selectedPath;
                    MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                    for (MenuElement element : selectedPath = manager.getSelectedPath()) {
                        if (!element.equals(DarkMenuUI.this.menu)) continue;
                        return;
                    }
                }
                super.mouseEntered(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.pressed = true;
                this.wasEnabled = DarkMenuUI.this.menu.isEnabled() && DarkMenuUI.this.menu.isSelected() && DarkMenuUI.this.menu.getPopupMenu().isShowing();
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!DarkMenuUI.this.menu.isEnabled()) {
                    return;
                }
                if (this.pressed && this.wasEnabled) {
                    this.pressed = false;
                    return;
                }
                super.mouseReleased(e);
            }
        };
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.acceleratorFont = UIManager.getFont("Menu.font");
        this.acceleratorForeground = UIManager.getColor("Menu.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIconHover = UIManager.getIcon("Menu.arrowHover.icon");
        this.arrowIconDisabled = UIManager.getIcon("Menu.arrowDisabled.icon");
        this.useEvenHeight = !Boolean.TRUE.equals(UIManager.get(this.getPropertyPrefix() + ".evenHeight"));
        this.acceleratorTextOffset = UIManager.getInt(this.getPropertyPrefix() + ".acceleratorTextOffset");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintMenuItemImpl(g, c, this.checkIcon, this.getArrowIcon(), this.defaultTextIconGap);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return this.getPreferredMenuItemSizeImpl(c, checkIcon, arrowIcon, defaultTextIconGap);
    }

    protected Icon getArrowIcon() {
        if (!this.menuItem.isEnabled()) {
            return this.arrowIconDisabled;
        }
        boolean hover = this.menuItem.getModel().isArmed() || this.menuItem instanceof JMenu && this.menuItem.getModel().isSelected();
        return hover ? this.arrowIconHover : this.arrowIcon;
    }

    @Override
    public MenuItemLayoutHelper getMenuItemLayoutHelper(Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, JMenuItem mi, Rectangle viewRect) {
        return DarkMenuItemUIBase.getMenuItemLayoutHelperImpl(this.acceleratorDelimiter, this.acceleratorFont, this.getPropertyPrefix(), checkIcon, arrowIcon, defaultTextIconGap, mi, viewRect);
    }

    @Override
    public String getPropertyPrefix() {
        return super.getPropertyPrefix();
    }

    @Override
    public Color getDisabledBackground() {
        return this.menu.getBackground();
    }

    @Override
    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    @Override
    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    @Override
    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    @Override
    public Color getAcceleratorSelectionForeground() {
        return this.acceleratorSelectionForeground;
    }

    @Override
    public Color getAcceleratorForeground() {
        return this.acceleratorForeground;
    }

    @Override
    public int getAcceleratorTextOffset() {
        return this.acceleratorTextOffset;
    }

    @Override
    public boolean isUseEvenHeight() {
        return this.useEvenHeight;
    }
}

