/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties;

import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.properties.parser.ParseResult;
import com.github.weisj.darklaf.properties.parser.Parser;
import com.github.weisj.darklaf.properties.parser.ParserContext;
import com.github.weisj.darklaf.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;

public final class PropertyLoader {
    private static final Logger LOGGER = LogUtil.getLogger(PropertyLoader.class);
    private static final char REFERENCE_PREFIX = '%';

    public static Properties loadProperties(Class<?> clazz, String name, String path) {
        Properties properties = new Properties();
        String p = path + name + ".properties";
        try (InputStream stream = clazz.getResourceAsStream(p);){
            properties.load(stream);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.log(Level.SEVERE, "Could not load " + p + " " + e.getMessage(), e);
        }
        return properties;
    }

    public static void putProperties(Properties properties, Properties accumulator, UIDefaults currentDefaults, IconResolver iconResolver) {
        PropertyLoader.putProperties(properties, properties.stringPropertyNames(), accumulator, currentDefaults, iconResolver);
    }

    public static void putProperties(Properties properties, UIDefaults defaults, IconResolver iconResolver) {
        PropertyLoader.putProperties(properties, properties.stringPropertyNames(), defaults, defaults, iconResolver);
    }

    public static void putProperties(Map<Object, Object> properties, Set<String> keys, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconResolver iconResolver) {
        ParserContext context = new ParserContext(accumulator, currentDefaults, iconResolver);
        for (String key : keys) {
            String value = properties.get(key).toString();
            ParseResult parseResult = Parser.parse(Parser.createParseResult(key, value), context);
            if (!parseResult.finished) continue;
            Object result = parseResult.result;
            if (result != null) {
                if (Parser.isDebugMode()) {
                    accumulator.put(parseResult.key, parseResult);
                    continue;
                }
                accumulator.put(parseResult.key, result);
                continue;
            }
            currentDefaults.remove(parseResult.key);
        }
    }

    public static void replaceProperties(Map<Object, Object> properties, Predicate<Map.Entry<Object, Object>> predicate, Function<Map.Entry<Object, Object>, Object> mapper) {
        PropertyLoader.replacePropertyEntriesOfType(Object.class, properties, predicate, mapper);
    }

    public static <T> void replacePropertiesOfType(Class<T> type, Map<Object, Object> properties, Function<T, T> mapper) {
        PropertyLoader.replacePropertyEntriesOfType(type, properties, e -> true, e -> mapper.apply(e.getValue()));
    }

    public static <T> void replacePropertiesOfType(Class<T> type, Map<Object, Object> properties, Predicate<Map.Entry<Object, T>> predicate, Function<T, T> mapper) {
        PropertyLoader.replacePropertyEntriesOfType(type, properties, predicate, e -> mapper.apply(e.getValue()));
    }

    public static <T> void replacePropertyEntriesOfType(Class<T> type, Map<Object, Object> properties, Predicate<Map.Entry<Object, T>> predicate, Function<Map.Entry<Object, T>, T> mapper) {
        properties.entrySet().stream().filter(e -> type == Object.class || type.isInstance(e.getValue())).filter(e -> predicate.test((Map.Entry)e)).forEach(e -> Optional.ofNullable(mapper.apply((Map.Entry)e)).ifPresent(e::setValue));
    }

    public static String getReferencePrefix() {
        return String.valueOf('%');
    }
}

