/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.Interpolator;
import com.google.errorprone.annotations.Immutable;

@Immutable
public enum DefaultInterpolator implements Interpolator
{
    LINEAR(x -> x),
    EASE_IN_SINE(x -> (float)(1.0 - Math.cos((double)x * Math.PI / 2.0))),
    EASE_OUT_SINE(x -> (float)Math.sin((double)x * Math.PI / 2.0)),
    EASE_IN_QUAD(x -> x * x),
    EASE_OUT_QUAD(x -> {
        float tmp = 1.0f - x;
        return 1.0f - tmp * tmp;
    }),
    EASE_IN_CUBIC(x -> x * x * x),
    EASE_OUT_CUBIC(x -> {
        float tmp = 1.0f - x;
        return 1.0f - tmp * tmp * tmp;
    });

    private final Interpolator delegate;

    private DefaultInterpolator(Interpolator delegate) {
        this.delegate = delegate;
    }

    @Override
    public float interpolate(float fraction) {
        return this.delegate.interpolate(fraction);
    }
}

