/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.hotswap;

import java.lang.reflect.Field;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class TransformHelper {
    static Field classLoaderExceptionsField;
    static Field xformerExceptionsField;

    public static byte[] transform(LaunchClassLoader loader, String name, byte[] classBytes) throws Exception {
        if (classLoaderExceptionsField == null) {
            classLoaderExceptionsField = loader.getClass().getDeclaredField("classLoaderExceptions");
            classLoaderExceptionsField.setAccessible(true);
        }
        if (xformerExceptionsField == null) {
            xformerExceptionsField = loader.getClass().getDeclaredField("transformerExceptions");
            xformerExceptionsField.setAccessible(true);
        }
        Set loaderExceptions = (Set)classLoaderExceptionsField.get(loader);
        Set xformerExceptions = (Set)xformerExceptionsField.get(loader);
        for (String exception : loaderExceptions) {
            if (!name.startsWith(exception)) continue;
            return classBytes;
        }
        for (String exception : xformerExceptions) {
            if (!name.startsWith(exception)) continue;
            return classBytes;
        }
        for (IClassTransformer xformer : loader.getTransformers()) {
            classBytes = xformer.transform(name, name, classBytes);
        }
        return classBytes;
    }
}

