/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.textures;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import me.eigenraven.lwjgl3ify.textures.FastByteChannel;
import org.apache.commons.io.IOUtils;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NativeBackedImage
extends BufferedImage
implements AutoCloseable {
    private final int width;
    private final int height;
    private long pointer;
    private final int sizeBytes;

    private NativeBackedImage(int width, int height, long pointer) {
        super(width, height, 2);
        this.width = width;
        this.height = height;
        this.pointer = pointer;
        this.sizeBytes = width * height * 4;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        for (int z = startY; z < h; ++z) {
            for (int x = startX; x < w; ++x) {
                int finalColor;
                int color = MemoryUtil.memGetInt((long)(this.pointer + (long)((x + z * this.width) * 4)));
                int a = color >> 24 & 0xFF;
                int b = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int r = color >> 0 & 0xFF;
                rgbArray[x + z * this.width] = finalColor = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return rgbArray;
    }

    @Override
    public int getRGB(int x, int z) {
        this.checkBounds(x, z);
        return MemoryUtil.memGetInt((long)(this.pointer + (long)((x + z * this.width) * 4)));
    }

    @Override
    public void setRGB(int x, int z, int rgb) {
        this.checkBounds(x, z);
        MemoryUtil.memPutInt((long)(this.pointer + (long)((x + z * this.width) * 4)), (int)rgb);
    }

    @Override
    public BufferedImage getSubimage(int x, int y, int w, int h) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void close() throws Exception {
        if (this.pointer != 0L) {
            STBImage.nstbi_image_free((long)this.pointer);
            this.pointer = 0L;
        }
    }

    private void checkBounds(int x, int z) {
        if (x < 0 || x >= this.width || z < 0 || z >= this.height) {
            throw new IllegalStateException("Out of bounds: " + x + ", " + z + " (width: " + this.width + ", height: " + this.height + ")");
        }
    }

    public static NativeBackedImage make(InputStream stream) throws IOException {
        ByteBuffer imgBuf = null;
        try {
            NativeBackedImage nativeBackedImage;
            block10: {
                imgBuf = NativeBackedImage.readResource(stream);
                imgBuf.rewind();
                MemoryStack memoryStack = MemoryStack.stackPush();
                try {
                    IntBuffer width = memoryStack.mallocInt(1);
                    IntBuffer height = memoryStack.mallocInt(1);
                    IntBuffer channels = memoryStack.mallocInt(1);
                    ByteBuffer buf = STBImage.stbi_load_from_memory((ByteBuffer)imgBuf, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
                    if (buf == null) {
                        throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                    }
                    nativeBackedImage = new NativeBackedImage(width.get(0), height.get(0), MemoryUtil.memAddress((ByteBuffer)buf));
                    if (memoryStack == null) break block10;
                }
                catch (Throwable throwable) {
                    if (memoryStack != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                memoryStack.close();
            }
            return nativeBackedImage;
        }
        finally {
            MemoryUtil.memFree((Buffer)imgBuf);
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static ByteBuffer readResource(InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer;
        if (inputStream instanceof FileInputStream) {
            FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
            byteBuffer = MemoryUtil.memAlloc((int)((int)fileChannel.size() + 1));
            while (fileChannel.read(byteBuffer) != -1) {
            }
        } else {
            int sizeGuess = 4096;
            try {
                sizeGuess = Math.max(4096, inputStream.available());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byteBuffer = MemoryUtil.memAlloc((int)(sizeGuess * 2));
            FastByteChannel readableByteChannel = new FastByteChannel(inputStream);
            while (readableByteChannel.read(byteBuffer) != -1) {
                if (byteBuffer.remaining() != 0) continue;
                byteBuffer = MemoryUtil.memRealloc((ByteBuffer)byteBuffer, (int)(byteBuffer.capacity() * 2));
            }
        }
        return byteBuffer;
    }
}

