/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.test.spaceinvaders;

import org.lwjglx.test.spaceinvaders.AlienEntity;
import org.lwjglx.test.spaceinvaders.Entity;
import org.lwjglx.test.spaceinvaders.Game;

public class ShotEntity
extends Entity {
    private static final int TOP_BORDER = -100;
    private float moveSpeed = -300.0f;
    private Game game;
    private boolean used;

    public ShotEntity(Game game, String sprite, int x, int y) {
        super(game.getSprite(sprite), x, y);
        this.game = game;
        this.dy = this.moveSpeed;
    }

    public void reinitialize(int x, int y) {
        this.x = x;
        this.y = y;
        this.used = false;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.y < -100.0f) {
            this.game.removeEntity(this);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof AlienEntity) {
            this.game.removeEntity(this);
            this.game.removeEntity(other);
            this.game.notifyAlienKilled();
            this.used = true;
        }
    }
}

