/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import java.awt.Canvas;
import java.awt.event.KeyEvent;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.core.Config;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.Struct;
import org.lwjglx.Sys;
import org.lwjglx.input.KeyCodes;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import org.lwjglx.opengl.ContextAttribs;
import org.lwjglx.opengl.DisplayImplementation;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.Drawable;
import org.lwjglx.opengl.DrawableGL;
import org.lwjglx.opengl.PixelFormat;
import org.lwjglx.opengl.Sync;

public class Display {
    private static String windowTitle = "Game";
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = false;
    private static boolean startFullscreen = false;
    private static DisplayMode mode = new DisplayMode(854, 480);
    private static DisplayMode desktopDisplayMode = new DisplayMode(854, 480);
    private static int latestEventKey = 0;
    private static int displayX = 0;
    private static int displayY = 0;
    private static boolean displayResized = false;
    private static int displayWidth = 0;
    private static int displayHeight = 0;
    private static int displayFramebufferWidth = 0;
    private static int displayFramebufferHeight = 0;
    private static boolean latestResized = false;
    private static int latestWidth = 0;
    private static int latestHeight = 0;
    private static boolean cancelNextChar = false;
    private static Keyboard.KeyEvent ingredientKeyEvent;
    private static ByteBuffer[] savedIcons;
    private static int[] savedX;
    private static int[] savedY;
    private static int[] savedW;
    private static int[] savedH;
    protected static DrawableGL drawable;

    public static void create(PixelFormat pixel_format, Drawable shared_drawable) {
        System.out.println("TODO: Implement Display.create(PixelFormat, Drawable)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format, ContextAttribs attribs) {
        System.out.println("TODO: Implement Display.create(PixelFormat, ContextAttribs)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format) {
        System.out.println("TODO: Implement Display.create(PixelFormat)");
        Display.create();
    }

    public static void create() {
        if (displayCreated) {
            return;
        }
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)1);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)2);
        GLFW.glfwWindowHint((int)139267, (int)1);
        GLFW.glfwWindowHint((int)131080, (int)(Config.WINDOW_START_MAXIMIZED ? 1 : 0));
        GLFW.glfwWindowHint((int)131073, (int)(Config.WINDOW_START_FOCUSED ? 1 : 0));
        displayFocused = Config.WINDOW_START_FOCUSED;
        GLFW.glfwWindowHint((int)131074, (int)(Config.WINDOW_START_ICONIFIED ? 1 : 0));
        displayVisible = !Config.WINDOW_START_ICONIFIED;
        GLFW.glfwWindowHint((int)131077, (int)(Config.WINDOW_DECORATED ? 1 : 0));
        GLFW.glfwWindowHint((int)135182, (int)(Config.OPENGL_SRGB_CONTEXT ? 1 : 0));
        GLFW.glfwWindowHint((int)135184, (int)(Config.OPENGL_DOUBLEBUFFER ? 1 : 0));
        GLFW.glfwWindowHint((int)139274, (int)(Config.OPENGL_CONTEXT_NO_ERROR ? 1 : 0));
        GLFW.glfwWindowHint((int)139271, (int)(Config.OPENGL_DEBUG_CONTEXT ? 1 : 0));
        GLFW.glfwWindowHint((int)139271, (int)(Config.OPENGL_DEBUG_CONTEXT ? 1 : 0));
        GLFW.glfwWindowHintString((int)147457, (CharSequence)Config.X11_CLASS_NAME);
        GLFW.glfwWindowHintString((int)143362, (CharSequence)Config.COCOA_FRAME_NAME);
        GLFW.glfwWindowHint((int)143361, (int)0);
        Window.handle = GLFW.glfwCreateWindow((int)mode.getWidth(), (int)mode.getHeight(), (CharSequence)windowTitle, (long)0L, (long)0L);
        if (Window.handle == 0L) {
            throw new IllegalStateException("Failed to create Display window");
        }
        Window.keyCallback = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                if (Config.DEBUG_PRINT_KEY_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-KEY] key window:{} key:{} scancode:{} action:{} mods:{} charname:{} naive-char:{}", new Object[]{window, key, scancode, action, mods, KeyEvent.getKeyText(KeyCodes.lwjglToAwt(KeyCodes.glfwToLwjgl(key))), Character.valueOf(key >= 32 && key < 127 ? (char)key : (char)'?')});
                }
                cancelNextChar = false;
                if (key > 32 && key <= 96) {
                    if ((2 & mods) != 0) {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        cancelNextChar = true;
                    } else if (action > 0) {
                        ingredientKeyEvent = new Keyboard.KeyEvent(KeyCodes.glfwToLwjgl(key), '\u0000', action > 1 ? Keyboard.KeyState.REPEAT : Keyboard.KeyState.PRESS, Sys.getNanoTime());
                    } else {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, '\u0000');
                    }
                } else {
                    char c;
                    switch (key) {
                        case 257: {
                            c = '\r';
                            break;
                        }
                        case 256: {
                            c = '\u001b';
                            break;
                        }
                        case 258: {
                            c = '\t';
                            break;
                        }
                        case 259: {
                            c = '\b';
                            break;
                        }
                        default: {
                            c = '\u0000';
                        }
                    }
                    char mappedChar = c;
                    Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, mappedChar);
                }
            }
        };
        Window.charCallback = new GLFWCharCallback(){

            public void invoke(long window, int codepoint) {
                if (Config.DEBUG_PRINT_KEY_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-KEY] char window:{} codepoint:{} char:{}", new Object[]{window, codepoint, Character.valueOf((char)codepoint)});
                }
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else if (ingredientKeyEvent != null) {
                    ingredientKeyEvent.aChar = (char)codepoint;
                    Keyboard.eventQueue.add(ingredientKeyEvent);
                    ingredientKeyEvent = null;
                } else {
                    Keyboard.addCharEvent(0, (char)codepoint);
                }
            }
        };
        Window.cursorPosCallback = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] cursorPos window:{} xpos:{} ypos:{}", new Object[]{window, xpos, ypos});
                }
                Mouse.addMoveEvent(xpos, ypos);
            }
        };
        Window.mouseButtonCallback = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] button window:{} button:{} action:{} mods:{}", new Object[]{window, button, action, mods});
                }
                Mouse.addButtonEvent(button, action == 1);
            }
        };
        Window.scrollCallback = new GLFWScrollCallback(){

            public void invoke(long window, double xoffset, double yoffset) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] wheel window:{} xoffset:{} yoffset:{}", new Object[]{window, xoffset, yoffset});
                }
                Mouse.addWheelEvent(yoffset);
            }
        };
        Window.windowFocusCallback = new GLFWWindowFocusCallback(){

            public void invoke(long window, boolean focused) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] focus window:{} focus:{}", new Object[]{window, focused});
                }
                displayFocused = focused;
            }
        };
        Window.windowIconifyCallback = new GLFWWindowIconifyCallback(){

            public void invoke(long window, boolean iconified) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] focus window:{} iconified:{}", new Object[]{window, iconified});
                }
                displayVisible = !iconified;
            }
        };
        Window.windowSizeCallback = new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] window-resize window:{} w:{} h:{}", new Object[]{window, width, height});
                }
                latestResized = true;
                latestWidth = width;
                latestHeight = height;
            }
        };
        Window.windowPosCallback = new GLFWWindowPosCallback(){

            public void invoke(long window, int xpos, int ypos) {
                displayX = xpos;
                displayY = ypos;
            }
        };
        Window.windowRefreshCallback = new GLFWWindowRefreshCallback(){

            public void invoke(long window) {
                displayDirty = true;
            }
        };
        Window.framebufferSizeCallback = new GLFWFramebufferSizeCallback(){

            public void invoke(long window, int width, int height) {
                if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-MOUSE] framebuffer-resize window:{} w:{} h:{}", new Object[]{window, width, height});
                }
                displayFramebufferWidth = width;
                displayFramebufferHeight = height;
            }
        };
        Window.setCallbacks();
        displayWidth = mode.getWidth();
        displayHeight = mode.getHeight();
        IntBuffer fbw = org.lwjglx.BufferUtils.createIntBuffer(1);
        IntBuffer fbh = org.lwjglx.BufferUtils.createIntBuffer(1);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (IntBuffer)fbw, (IntBuffer)fbh);
        displayFramebufferWidth = fbw.get(0);
        displayFramebufferHeight = fbh.get(0);
        displayX = (monitorWidth - mode.getWidth()) / 2;
        displayY = (monitorHeight - mode.getHeight()) / 2;
        GLFW.glfwMakeContextCurrent((long)Window.handle);
        drawable = new DrawableGL();
        GL.createCapabilities();
        if (savedIcons != null) {
            Display.setIcon(savedIcons);
            savedIcons = null;
        }
        GLFW.glfwSwapInterval((int)1);
        displayCreated = true;
        if (startFullscreen) {
            Display.setFullscreen(true);
        }
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowSize((long)Window.handle, (int[])x, (int[])y);
        Window.windowSizeCallback.invoke(Window.handle, x[0], y[0]);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (int[])x, (int[])y);
        Window.framebufferSizeCallback.invoke(Window.handle, x[0], y[0]);
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int new_x, int new_y) {
        System.out.println("TODO: Implement Display.setLocation(int, int)");
    }

    public static void setVSyncEnabled(boolean sync) {
        GLFW.glfwSwapInterval((int)(sync ? 1 : 0));
    }

    public static long getWindow() {
        return Window.handle;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        Display.swapBuffers();
        displayDirty = false;
        if (processMessages) {
            Display.processMessages();
        }
    }

    public static void processMessages() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        if (latestResized) {
            latestResized = false;
            displayResized = true;
            displayWidth = latestWidth;
            displayHeight = latestHeight;
        } else {
            displayResized = false;
        }
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers((long)Window.handle);
    }

    public static void destroy() {
        Window.releaseCallbacks();
        GLFW.glfwDestroyWindow((long)Window.handle);
        displayCreated = false;
    }

    public static void setDisplayMode(DisplayMode dm) {
        mode = dm;
    }

    public static DisplayMode getDisplayMode() {
        return mode;
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        IntBuffer count = org.lwjglx.BufferUtils.createIntBuffer(1);
        GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes((long)GLFW.glfwGetPrimaryMonitor());
        DisplayMode[] displayModes = new DisplayMode[count.get(0)];
        for (int i = 0; i < count.get(0); ++i) {
            modes.position(i * GLFWVidMode.SIZEOF);
            int w = modes.width();
            int h = modes.height();
            int b = modes.redBits() + modes.greenBits() + modes.blueBits();
            int r = modes.refreshRate();
            displayModes[i] = new DisplayMode(w, h, b, r);
        }
        return displayModes;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static boolean wasResized() {
        return displayResized;
    }

    public static int getX() {
        return displayX;
    }

    public static int getY() {
        return displayY;
    }

    public static int getWidth() {
        return displayWidth;
    }

    public static int getHeight() {
        return displayHeight;
    }

    public static int getFramebufferWidth() {
        return displayFramebufferWidth;
    }

    public static int getFramebufferHeight() {
        return displayFramebufferHeight;
    }

    public static void setTitle(String title) {
        windowTitle = title;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)Window.handle);
    }

    public static boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float red, float green, float blue) {
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (Display.getWindow() == 0L) {
            savedIcons = icons;
            return 0;
        }
        GLFWImage.Buffer glfwImages = GLFWImage.calloc((int)icons.length);
        ByteBuffer[] nativeBuffers = new ByteBuffer[icons.length];
        for (int icon = 0; icon < icons.length; ++icon) {
            nativeBuffers[icon] = BufferUtils.createByteBuffer((int)icons[icon].capacity());
            nativeBuffers[icon].put(icons[icon]);
            nativeBuffers[icon].flip();
            int dimension = (int)Math.sqrt((double)nativeBuffers[icon].limit() / 4.0);
            if (dimension * dimension * 4 != nativeBuffers[icon].limit()) {
                throw new IllegalStateException();
            }
            glfwImages.put(icon, (Struct)GLFWImage.create().set(dimension, dimension, nativeBuffers[icon]));
        }
        GLFW.glfwSetWindowIcon((long)Display.getWindow(), (GLFWImage.Buffer)glfwImages);
        glfwImages.free();
        return 0;
    }

    public static void setResizable(boolean resizable) {
        displayResizable = resizable;
    }

    public static boolean isResizable() {
        return displayResizable;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        System.out.println("TODO: Implement Display.setDisplayModeAndFullscreen(DisplayMode)");
    }

    public static void setFullscreen(boolean fullscreen) {
        long window = Display.getWindow();
        if (window == 0L) {
            startFullscreen = fullscreen;
            return;
        }
        boolean currentState = Display.isFullscreen();
        if (currentState == fullscreen) {
            return;
        }
        if (fullscreen) {
            GLFW.glfwGetWindowPos((long)window, (int[])savedX, (int[])savedY);
            GLFW.glfwGetWindowSize((long)window, (int[])savedW, (int[])savedH);
            long monitorId = GLFW.glfwGetPrimaryMonitor();
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitorId);
            GLFW.glfwSetWindowMonitor((long)window, (long)monitorId, (int)0, (int)0, (int)vidMode.width(), (int)vidMode.height(), (int)vidMode.refreshRate());
        } else {
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)savedX[0], (int)savedY[0], (int)savedW[0], (int)savedH[0], (int)0);
        }
    }

    public static boolean isFullscreen() {
        if (Display.getWindow() != 0L) {
            return GLFW.glfwGetWindowMonitor((long)Display.getWindow()) != 0L;
        }
        return false;
    }

    public static void setParent(Canvas parent) {
    }

    public static void releaseContext() {
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    public static boolean isCurrent() {
        return true;
    }

    public static void makeCurrent() {
        GLFW.glfwMakeContextCurrent((long)Window.handle);
    }

    public static String getAdapter() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7936);
        }
        return "Unknown";
    }

    public static String getVersion() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7938);
        }
        return "Unknown";
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    static DisplayImplementation getImplementation() {
        return null;
    }

    static {
        Sys.initialize();
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        savedX = new int[1];
        savedY = new int[1];
        savedW = new int[1];
        savedH = new int[1];
        drawable = null;
    }

    private static class Window {
        static long handle;
        static GLFWKeyCallback keyCallback;
        static GLFWCharCallback charCallback;
        static GLFWCursorPosCallback cursorPosCallback;
        static GLFWMouseButtonCallback mouseButtonCallback;
        static GLFWScrollCallback scrollCallback;
        static GLFWWindowFocusCallback windowFocusCallback;
        static GLFWWindowIconifyCallback windowIconifyCallback;
        static GLFWWindowSizeCallback windowSizeCallback;
        static GLFWWindowPosCallback windowPosCallback;
        static GLFWWindowRefreshCallback windowRefreshCallback;
        static GLFWFramebufferSizeCallback framebufferSizeCallback;

        private Window() {
        }

        public static void setCallbacks() {
            GLFW.glfwSetKeyCallback((long)handle, (GLFWKeyCallbackI)keyCallback);
            GLFW.glfwSetCharCallback((long)handle, (GLFWCharCallbackI)charCallback);
            GLFW.glfwSetCursorPosCallback((long)handle, (GLFWCursorPosCallbackI)cursorPosCallback);
            GLFW.glfwSetMouseButtonCallback((long)handle, (GLFWMouseButtonCallbackI)mouseButtonCallback);
            GLFW.glfwSetScrollCallback((long)handle, (GLFWScrollCallbackI)scrollCallback);
            GLFW.glfwSetWindowFocusCallback((long)handle, (GLFWWindowFocusCallbackI)windowFocusCallback);
            GLFW.glfwSetWindowIconifyCallback((long)handle, (GLFWWindowIconifyCallbackI)windowIconifyCallback);
            GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)windowSizeCallback);
            GLFW.glfwSetWindowPosCallback((long)handle, (GLFWWindowPosCallbackI)windowPosCallback);
            GLFW.glfwSetWindowRefreshCallback((long)handle, (GLFWWindowRefreshCallbackI)windowRefreshCallback);
            GLFW.glfwSetFramebufferSizeCallback((long)handle, (GLFWFramebufferSizeCallbackI)framebufferSizeCallback);
        }

        public static void releaseCallbacks() {
            keyCallback.free();
            charCallback.free();
            cursorPosCallback.free();
            mouseButtonCallback.free();
            scrollCallback.free();
            windowFocusCallback.free();
            windowIconifyCallback.free();
            windowSizeCallback.free();
            windowPosCallback.free();
            windowRefreshCallback.free();
            framebufferSizeCallback.free();
        }
    }
}

